/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductAwareLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderBindingUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class PeakQuantityField
extends AbstractProductAwareLongDisplayValueField {
    public PeakQuantityField() {
    }

    public PeakQuantityField(LongDisplayValue initialValue) {
        super(initialValue);
    }

    public PeakQuantityField(LongDisplayValue initialValue, int delta) {
        super(initialValue, delta);
    }

    public void init(final ReadOnlyObjectProperty<Contract> contract, final ReadOnlyObjectProperty<OrderType> orderType, ReadOnlyObjectProperty<LongDisplayValue> quantity) {
        this.productProperty().bind(OrderBindingUtil.productBinding(contract));
        this.promptTextProperty().bind((ObservableValue<String>)new DependentBinding<String>(this, new Observable[]{orderType}){

            @Override
            protected String computeValue() {
                if (orderType.getValue() == OrderType.ICEBERG) {
                    return Util.getLabel("commons_peak");
                }
                return null;
            }
        });
        this.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            Contract contractValue = (Contract)contract.get();
            if (contractValue != null) {
                Product product = contractValue.getProduct();
                if (!oldValue.booleanValue() && newValue.booleanValue() || this.isValid()) {
                    LongDisplayValue oldPeakQuantity = this.getValue();
                    this.setValue((oldPeakQuantity != null ? oldPeakQuantity : LongDisplayValue.ZERO).applyShift(product.getQuantityDecimalShift()));
                    this.setDelta((int)product.getQuantityLotSize().getValue());
                    this.selectAllIfFocused();
                }
                if (this.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                    this.setValue(this.getValue().applyShift(product.getQuantityDecimalShift()));
                }
            }
        });
        orderType.addListener((observableValue, oldValue, newValue) -> {
            if (newValue != OrderType.ICEBERG) {
                this.setValue(null);
            }
        });
        this.maximumProperty().bind(quantity);
        this.minimumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(this, new Observable[]{orderType, contract}){

            @Override
            protected LongDisplayValue computeValue() {
                Contract contractValue = (Contract)contract.getValue();
                if (contractValue != null && orderType.getValue() == OrderType.ICEBERG) {
                    Product product = contractValue.getProduct();
                    return product.getIcebergMinPeakSize();
                }
                return new LongDisplayValue(0L, 0);
            }
        });
        this.disableProperty().bind(Bindings.or(orderType.isNotEqualTo(OrderType.ICEBERG), Bindings.isNull(contract)));
    }

    @Override
    public LongDisplayValue getInitialValue() {
        return LongDisplayValue.ZERO.applyShift(this.getProduct().getQuantityDecimalShift());
    }

    @Override
    public Node getPreviewForConfigTable() {
        PeakQuantityField simpleLongDisplayValueField = new PeakQuantityField(this.getValue());
        simpleLongDisplayValueField.setValue(this.getValue());
        simpleLongDisplayValueField.prefWidthProperty().bind(this.widthProperty());
        simpleLongDisplayValueField.setDisable(true);
        return simpleLongDisplayValueField;
    }
}

