/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.ExportTradingDaysChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ImportExportService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ContinuousTradeExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.ContinuousTradeExportState;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OverrideGuiConfiguration(field="#this", overrideId="ExportSettingsPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class ExportSettingsPane
extends GridPane
implements SettingsSection {
    private static final Logger LOG = LoggerFactory.getLogger(ExportSettingsPane.class);
    private final ImportExportService importExportService;
    private final ContinuousTradeExportService continuousTradeExportService;
    private final ExecutorService executorService;
    private final UserAlertService userAlertService;
    private final ApplicationContext appContext;
    @FXML
    private CheckBox continuousExportCheckBox;
    @FXML
    private ToggleGroup tradeExportModeToggleGroup;
    @FXML
    private RadioButton myTradesRadioButton;
    @FXML
    private RadioButton allTradesRadioButton;
    @FXML
    private TextField filenameField;
    @FXML
    private ExportTradingDaysChoiceBox tradingDaysChoiceBox;

    public ExportSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ExportSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.importExportService = appContext.getService(ImportExportService.class);
        this.continuousTradeExportService = appContext.getService(ContinuousTradeExportService.class);
        this.executorService = appContext.getService(ExecutorService.class, WorkerExecutor.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.myTradesRadioButton.disableProperty().bind(this.continuousExportCheckBox.selectedProperty());
        this.allTradesRadioButton.disableProperty().bind(this.continuousExportCheckBox.selectedProperty());
        this.tradingDaysChoiceBox.disableProperty().bind(this.continuousExportCheckBox.selectedProperty());
        this.filenameField.disableProperty().bind(this.continuousExportCheckBox.selectedProperty());
        this.refreshSettings(this.continuousTradeExportService.getContinuousTradeExportState());
        this.appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    private void refreshSettings(ContinuousTradeExportState continuousTradeExportState) {
        this.continuousExportCheckBox.setSelected(continuousTradeExportState.isEnabled());
        if (Platform.isFxApplicationThread()) {
            this.tradingDaysChoiceBox.setValue(continuousTradeExportState.getTradingDays());
        }
        Toggle selectedToggle = this.tradeExportModeToggleGroup.getSelectedToggle();
        if (continuousTradeExportState.getMode() == ContinuousTradeExportService.Mode.ALL_TRADES) {
            if (!this.allTradesRadioButton.equals(selectedToggle)) {
                this.tradeExportModeToggleGroup.selectToggle(this.allTradesRadioButton);
            }
        } else if (!this.myTradesRadioButton.equals(selectedToggle)) {
            this.tradeExportModeToggleGroup.selectToggle(this.myTradesRadioButton);
        }
        this.filenameField.setText(continuousTradeExportState.getExportFile().getAbsolutePath());
    }

    @Override
    public boolean applyChanges() {
        ContinuousTradeExportState continuousTradeExportState = new ContinuousTradeExportState(this.continuousExportCheckBox.isSelected(), new File(this.filenameField.getText()), this.getSelectedExportMode(), (Integer)this.tradingDaysChoiceBox.getValue());
        Future<Boolean> exportEnabled = this.continuousTradeExportService.setContinuousTradeExportState(continuousTradeExportState);
        Runnable task = () -> {
            try {
                exportEnabled.get(3L, TimeUnit.SECONDS);
                this.refreshSettings(this.continuousTradeExportService.getContinuousTradeExportState());
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupted", e);
                Thread.currentThread().interrupt();
                return;
            }
            catch (ExecutionException | TimeoutException e) {
                LOG.error("Error while enabling trade export", e);
                this.refreshSettings(new ContinuousTradeExportState(false, new File(this.filenameField.getText()), this.getSelectedExportMode(), (Integer)this.tradingDaysChoiceBox.getValue()));
                this.userAlertService.showConfirmationDialog(Util.getLabel("continuousTradeExport_writeError_windowHeader"), Util.getLabel("continuousTradeExport_writeError_message", continuousTradeExportState.getExportFile().getAbsoluteFile()), UserAlertService.Flag.ERROR);
            }
        };
        this.executorService.submit(task);
        return true;
    }

    private ContinuousTradeExportService.Mode getSelectedExportMode() {
        return this.tradeExportModeToggleGroup.getSelectedToggle() == this.allTradesRadioButton ? ContinuousTradeExportService.Mode.ALL_TRADES : ContinuousTradeExportService.Mode.ONLY_MY_TRADES;
    }

    @Override
    public void cancelChanges() {
        this.refreshSettings(this.continuousTradeExportService.getContinuousTradeExportState());
    }

    @Override
    public void resetToDefault() {
        Boolean tradeExpEnabled = false;
        File exportFile = new File(ContinuousTradeExportService.DEFAULT_FILE_PATH);
        ContinuousTradeExportService.Mode exportMode = ContinuousTradeExportService.DEFAULT_MODE;
        int tradingDays = this.continuousTradeExportService.getDefaultTradingDays();
        this.refreshSettings(new ContinuousTradeExportState(tradeExpEnabled, exportFile, exportMode, tradingDays));
    }

    @FXML
    public void selectFile() {
        File newSelectedFile = this.importExportService.showFilePopup(this.getScene().getWindow(), ImportExportService.IODirection.EXPORT, Util.getLabel("settingsPanel_exportSettings_fileName", LocalDate.now().toString("yyyy-MM-dd")));
        if (newSelectedFile != null) {
            this.filenameField.setText(newSelectedFile.getAbsolutePath());
        }
    }
}

