/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelProductListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SoundEventEntry;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundEventType;
import com.deutscheboerse.comxerv.comtrader.jfx.service.sound.SoundService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.FailedOrderSubmissionEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class SoundSettingsPane
extends ScrollPane
implements SettingsSection {
    private final ApplicationContext appContext;
    private final SoundService soundService;
    private final DataModelProductListener productDataModelListener;
    private final List<SoundEvent> soundEvents;
    @FXML
    private VBox soundEventContainer;
    private final ObservableList<SoundEventEntry> soundEventEntries;

    public SoundSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public SoundSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.soundService = appContext.getService(SoundService.class);
        this.soundEvents = new ArrayList<SoundEvent>();
        this.soundEventEntries = FXCollections.observableArrayList();
        this.productDataModelListener = new DataModelProductListener(this::productAdded, this::productRemoved, this::removeAll);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        Bindings.bindContent(this.soundEventContainer.getChildren(), this.soundEventEntries);
        this.addSoundEvent(new SoundEvent(SoundEventType.FAILED_ORDER_ENTRY, FailedOrderSubmissionEvent.Type.ENTRY));
        this.addSoundEvent(new SoundEvent(SoundEventType.FAILED_ORDER_ENTRY, FailedOrderSubmissionEvent.Type.MODIFICATION));
        this.addSoundEvent(new SoundEvent(SoundEventType.URGENT_MESSAGE, SoundEventType.URGENT_MESSAGE_CLASSIFIER));
        if (appContext.getService(UserService.class).getOwnUserRoles().hasRole("ROLE_ADMIN")) {
            this.addSoundEvent(new SoundEvent(SoundEventType.TRADE_RECALL_REQUESTED, SoundEventType.TRADE_RECALL_REQUEST_MESSAGE_CLASSIFIER));
        }
        this.addSeparator();
        appContext.getSmallDataModel(Product.class).registerListener(new WeakDataModelListener<Product>(this.productDataModelListener));
    }

    private void removeAll() {
        this.soundEvents.removeIf(this::isEventForExchange);
        this.soundEventEntries.removeIf(entry -> this.isEventForExchange(entry.getSoundEvent()));
    }

    private boolean isEventForExchange(SoundEvent event) {
        return event.getClassifier() instanceof BroadcastEntity;
    }

    private void productRemoved(Product product) {
        SoundEvent soundEvent = new SoundEvent(SoundEventType.TRADE, product);
        this.soundEvents.remove(soundEvent);
        this.soundEventEntries.stream().filter(entry -> soundEvent.equals(entry.getSoundEvent())).findFirst().ifPresent(this.soundEventEntries::remove);
    }

    private void addSoundEvent(SoundEvent event) {
        this.soundEvents.add(event);
        SoundEventEntry soundEventEntry = this.getSoundEventEntry(event);
        this.soundEventEntries.add(soundEventEntry);
    }

    private void addSeparator() {
        SoundEventEntry soundEventEntry = (SoundEventEntry)this.soundEventEntries.get(this.soundEventEntries.size() - 1);
        soundEventEntry.getStyleClass().add("horizontalLineWithBottomMargin");
    }

    private void productAdded(Product product) {
        SoundEvent soundEvent = new SoundEvent(SoundEventType.TRADE, product);
        if (!this.soundEvents.contains(soundEvent)) {
            this.addSoundEvent(soundEvent);
        }
    }

    private SoundEventEntry getSoundEventEntry(SoundEvent soundEvent) {
        return new SoundEventEntry(this.appContext, soundEvent, this.soundService.getSound(soundEvent));
    }

    @Override
    public boolean applyChanges() {
        this.soundEventEntries.forEach(this::registerSoundEvent);
        return true;
    }

    private void registerSoundEvent(SoundEventEntry soundEventEntry) {
        this.soundService.registerSound(soundEventEntry.getSoundEvent(), soundEventEntry.getSelectedSoundType());
    }

    @Override
    public void cancelChanges() {
        this.soundEventEntries.forEach(this::restoreSoundEvent);
    }

    private void restoreSoundEvent(SoundEventEntry soundEventEntry) {
        soundEventEntry.setSelectedSoundType(this.soundService.getSound(soundEventEntry.getSoundEvent()));
    }

    @Override
    public void resetToDefault() {
        this.soundEventEntries.forEach(this::resetSoundEvent);
    }

    private void resetSoundEvent(SoundEventEntry soundEventEntry) {
        soundEventEntry.setSelectedSoundType(SoundService.DEFAULT_SOUND);
    }
}

