/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColoredTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.OrderbookTableRow;
import com.deutscheboerse.ui.jfx.util.binding.WeakDependentInvalidationListener;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import org.apache.commons.lang3.StringUtils;

public class ColorInvalidationListener {
    private ColorInvalidationListener() {
    }

    public static void registerForColoredTableColumn(TableColumn tableColumn, TableCell tableCell) {
        if (tableColumn instanceof ColoredTableColumn) {
            tableCell.tableColumnProperty().addListener(new ColumnChangeListener(tableCell));
        }
    }

    private static final class ColumnChangeListener
    implements ChangeListener<TableColumn> {
        private final WeakReference<TableCell> cellWeakRef;
        private final ChangeListener<String> styleChangeListener;
        private final ChangeListener<TableRow> tableRowChangeListener;

        private ColumnChangeListener(TableCell tableCell) {
            this.cellWeakRef = new WeakReference<TableCell>(tableCell);
            this.styleChangeListener = (observable2, oldValue, newValue) -> {
                if (StringUtils.isEmpty(newValue)) {
                    this.setCellColorFromColumn(tableCell);
                } else {
                    tableCell.setStyle(null);
                }
            };
            this.tableRowChangeListener = (observable2, oldValue, newValue) -> {
                if (newValue != null && newValue instanceof OrderbookTableRow) {
                    if (StringUtils.isNotEmpty(tableCell.getTableRow().getStyle())) {
                        tableCell.setStyle(null);
                    }
                    newValue.styleProperty().addListener(new WeakChangeListener<String>(this.styleChangeListener));
                }
            };
        }

        @Override
        public void changed(ObservableValue<? extends TableColumn> columnProperty, TableColumn oldColumn, TableColumn newColumn) {
            TableCell tableCell = (TableCell)this.cellWeakRef.get();
            if (tableCell == null) {
                columnProperty.removeListener(this);
            } else if (newColumn instanceof ColoredTableColumn) {
                this.tableColumnChanged((ColoredTableColumn)newColumn, tableCell);
            }
        }

        private void tableColumnChanged(ColoredTableColumn newColoredTableColumn, TableCell tableCell) {
            InvalidationListener colorListener = observable2 -> this.columnColorChanged();
            WeakDependentInvalidationListener weakColorListener = new WeakDependentInvalidationListener(colorListener, tableCell);
            newColoredTableColumn.colorAsCssBackgroundRuleProperty().addListener(weakColorListener);
            this.columnColorChanged();
        }

        private void columnColorChanged() {
            TableCell tableCell = (TableCell)this.cellWeakRef.get();
            if (tableCell == null || !(tableCell.getTableColumn() instanceof ColoredTableColumn)) {
                return;
            }
            tableCell.tableRowProperty().addListener(new WeakChangeListener<TableRow>(this.tableRowChangeListener));
            if (tableCell.getTableRow() != null && tableCell.getTableRow() instanceof OrderbookTableRow && StringUtils.isNotEmpty(tableCell.getTableRow().getStyle())) {
                tableCell.setStyle(null);
            } else {
                this.setCellColorFromColumn(tableCell);
            }
        }

        private void setCellColorFromColumn(TableCell<?, ?> tableCell) {
            String style = ((ColoredTableColumn)tableCell.getTableColumn()).getColorAsCssBackgroundRule();
            tableCell.setStyle(style);
        }
    }
}

