/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import javafx.beans.DefaultProperty;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;

@DefaultProperty(value="growColumn")
public class GrowColumnResizePolicy<S>
implements Callback<TableView.ResizeFeatures<S>, Boolean> {
    private TableColumn<S, ?> growColumn;
    private static int MARGIN = 11;

    @Override
    public Boolean call(TableView.ResizeFeatures<S> param) {
        if (param.getColumn() != null) {
            param.getColumn().setPrefWidth(param.getColumn().getWidth() + param.getDelta());
        }
        double remainingWidth = param.getTable().getWidth() - (double)MARGIN;
        for (TableColumn tableColumn : param.getTable().getVisibleLeafColumns()) {
            if (tableColumn.equals(this.growColumn)) continue;
            remainingWidth -= tableColumn.getWidth();
        }
        this.growColumn.setPrefWidth(remainingWidth);
        return true;
    }

    public TableColumn getGrowColumn() {
        return this.growColumn;
    }

    public void setGrowColumn(TableColumn growColumn) {
        this.growColumn = growColumn;
    }
}

