/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ExtendedOrderbookEntryTooltip
extends Tooltip {
    private final DataModel<Long, Order> orderDataModel;
    private final LocalService localService;

    @Inject
    public ExtendedOrderbookEntryTooltip(ApplicationContext appContext) {
        this.orderDataModel = appContext.getDataModel(Order.class);
        this.localService = appContext.getService(LocalService.class);
    }

    public void applyNewExtendedOrderbookEntry(ExtendedOrderbookEntry extendedOrderbookEntry) {
        if (extendedOrderbookEntry != null) {
            Order order = this.orderDataModel.findById(extendedOrderbookEntry.getOrderId());
            this.setText(this.getTooltipTextValue(order, extendedOrderbookEntry));
        } else {
            this.setText("");
        }
    }

    private String getTooltipTextValue(Order order, ExtendedOrderbookEntry entry) {
        StringBuilder tooltipText = new StringBuilder(400);
        if (order != null && order.getInitialQuantity() != null) {
            this.addToolTip(tooltipText, "commons_initialQuantityShort", order.getInitialQuantity().toString());
        }
        this.addToolTip(tooltipText, "commons_quantityShort", entry.getQuantity().toString());
        if (order != null && order.getPeakQuantity() != null) {
            this.addToolTip(tooltipText, "commons_totalQuantityShort", order.getRemainingQuantity());
        }
        this.addToolTip(tooltipText, "commons_priceShort", entry.getPrice().toString());
        if (StringUtils.isNotEmpty(entry.getOrderbook().getContract().getProduct().getTimeZone())) {
            this.addToolTip(tooltipText, "commons_timeZone", entry.getOrderbook().getContract().getProduct().getTimeZone());
        }
        this.addToolTip(tooltipText, "commons_currency", entry.getOrderbook().getContract().getProduct().getCurrencyCode());
        if (order != null && order.getDeliveryArea() != null) {
            this.addToolTip(tooltipText, "commons_area", order.getDeliveryArea().getDisplayName());
        }
        if (order != null) {
            this.addToolTip(tooltipText, "commons_orderType", order.getOrderType().getDisplayName());
            this.addToolTip(tooltipText, "commons_validityRestrictionShortest", order.getValidityRestriction().getDisplayName());
            if (ValidityRestriction.GOOD_TILL_DATE.equals(order.getValidityRestriction())) {
                this.addToolTip(tooltipText, "commons_validityDateShort", this.localService.formatDateTime(order.getValidityDate()));
            }
        }
        this.addToolTip(tooltipText, "commons_accQty", entry.getAccQuantity());
        this.addToolTip(tooltipText, "commons_vwapShort", entry.getVwap());
        this.addToolTip(tooltipText, "commons_timestamp", this.localService.formatDateTime(DateTimeUtils.mapLongToDateTime(entry.getServerTimestamp(), entry.getOrderbook().getExchange().getSystemInfo().getTimeZone())));
        if (order != null) {
            if (order.getExtendedValidityDate() != null) {
                this.addToolTip(tooltipText, "commons_extendedValidityDateShort", this.localService.formatDateTime(order.getExtendedValidityDate()));
            }
            if (order.getUser() != null) {
                this.addToolTip(tooltipText, "commons_user", order.getUser().getDisplayName());
                this.addToolTip(tooltipText, "commons_member", order.getUser().getMember().getDisplayName());
            } else {
                this.addToolTip(tooltipText, "commons_userCode", order.getTraderUserCode());
                this.addToolTip(tooltipText, "commons_member", order.getMemberCode());
            }
        }
        return tooltipText.toString();
    }

    private void addToolTip(StringBuilder tooltipText, String label, Object obj) {
        tooltipText.append(Util.getLabel(label)).append(": ").append(obj).append("\n");
    }
}

