/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.HubToHubQueries;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.h2h.ExtractDateStringFromIntervalConverter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.IntervalCallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SearchBox;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalTree
extends FXMLBorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(IntervalTree.class);
    private static final Comparator<TreeItem<Object>> TREE_ITEM_COMPARATOR = new IntervalTreeItemComparator();
    private final AbstractDataModelListener<HubToHub> hubToHubListener;
    private final HubToHubQueries hubToHubQueries;
    private final ExtractDateStringFromIntervalConverter extractDateStringFromIntervalConverter;
    private final IntervalCallback intervalCallback;
    @FXML
    private SearchBox searchBox;
    @FXML
    private VBox headerContainer;
    @FXML
    private TreeView<Object> intervalTreeView;
    private final CheckBoxTreeItem<Object> root;

    public IntervalTree(ApplicationContext appContext, final IntervalCallback intervalCallback) {
        super(appContext);
        this.intervalCallback = intervalCallback;
        this.hubToHubQueries = appContext.getService(HubToHubQueries.class);
        this.extractDateStringFromIntervalConverter = new ExtractDateStringFromIntervalConverter(appContext);
        this.root = new CheckBoxTreeItem<String>("Delivery periods");
        this.expandAll();
        this.loadFxml();
        Callback<TreeItem, ObservableValue> getSelectedProperty = item -> {
            if (item instanceof CheckBoxTreeItem) {
                return ((CheckBoxTreeItem)item).selectedProperty();
            }
            return null;
        };
        StringConverter<TreeItem<Object>> converter = new StringConverter<TreeItem<Object>>(){

            @Override
            public String toString(TreeItem<Object> object) {
                if (object.getValue() instanceof Interval) {
                    return IntervalTree.this.formatInterval((Interval)object.getValue());
                }
                return object.getValue().toString();
            }

            @Override
            public TreeItem<Object> fromString(String string) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        this.hubToHubListener = new AbstractDataModelListener<HubToHub>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(HubToHub object) {
                return IntervalTree.this.hubToHubAdded(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll(Collection<HubToHub> entities) {
                Multimap<Interval, HubToHub> entitiesInInterval = IntervalTree.this.hubToHubQueries.createDeliveryPeriodEntityMultimap();
                entities.forEach(entity -> {
                    if (entitiesInInterval.get(entity.getDeliveryPeriod()).stream().allMatch(item -> item.equals(entity))) {
                        intervalCallback.intervalSubscribed(entity.getDeliveryPeriod(), false);
                        IntervalTree.this.root.getChildren().removeIf(item -> entity.getDeliveryPeriod().equals(item.getValue()));
                    }
                });
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return IntervalTree.this.hubToHubRemoved();
            }
        };
        this.intervalTreeView.setCellFactory(param -> new CheckBoxTreeCell(getSelectedProperty, converter));
        this.intervalTreeView.setShowRoot(true);
        this.intervalTreeView.setRoot(this.root);
        this.getAppContext().getSmallDataModel(HubToHub.class).registerListener(new WeakDataModelListener<HubToHub>(this.hubToHubListener));
        this.searchBox.searchFilterProperty().addListener((observable2, oldValue, newValue) -> this.refilter((Optional<Predicate<Object>>)newValue));
        this.searchBox.showSwitchButton(false);
    }

    private void refilter(Optional<Predicate<Object>> newValue) {
        if (newValue.isPresent()) {
            LOG.debug("Filtering {}", (Object)newValue.get());
            this.intervalTreeView.setRoot(this.copyFiltered(this.root, newValue.get()));
            this.intervalTreeView.setShowRoot(false);
        } else {
            this.intervalTreeView.setRoot(this.root);
            this.intervalTreeView.setShowRoot(true);
        }
    }

    private CheckBoxTreeItem<Object> copyFiltered(CheckBoxTreeItem<Object> root, Predicate<Object> filter) {
        CheckBoxTreeItem<Object> filteredCopy = new CheckBoxTreeItem<Object>(root.getValue(), null, root.isSelected());
        root.getChildren().stream().filter(child -> filter.test(this.formatInterval((Interval)child.getValue()))).forEach(filteredCopy.getChildren()::add);
        return filteredCopy;
    }

    private DataModelListener.NotificationResult hubToHubAdded(HubToHub object) {
        if (!this.alreadyInTree(object.getDeliveryPeriod())) {
            this.root.getChildren().add(this.createTreeItem(object.getDeliveryPeriod(), this.isRootSelected()));
            this.root.getChildren().sort(TREE_ITEM_COMPARATOR);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private CheckBoxTreeItem<Object> createTreeItem(Interval interval, boolean selected) {
        CheckBoxTreeItem<Object> treeItem = new CheckBoxTreeItem<Object>(interval);
        treeItem.setIndependent(true);
        treeItem.selectedProperty().addListener((observable2, oldValue, newValue) -> this.intervalCallback.intervalSubscribed(interval, (boolean)newValue));
        treeItem.setSelected(selected);
        return treeItem;
    }

    private DataModelListener.NotificationResult hubToHubRemoved() {
        this.root.getChildren().clear();
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private boolean alreadyInTree(Interval interval) {
        return this.getIntervalItemsStream().map(TreeItem::getValue).anyMatch(interval::equals);
    }

    private Stream<TreeItem<Object>> getIntervalItemsStream() {
        return this.root.getChildren().stream();
    }

    public List<String> getSubscribedIntervals() {
        return this.getIntervalItemsStream().filter(item -> ((CheckBoxTreeItem)item).isSelected()).map(item -> this.formatInterval((Interval)item.getValue())).toList();
    }

    public void expandAll() {
        this.root.setExpanded(true);
    }

    public void collapseAll() {
        this.root.setExpanded(false);
    }

    private String formatInterval(Interval interval) {
        return this.extractDateStringFromIntervalConverter.toString(interval);
    }

    public boolean isRootSelected() {
        return this.root.isSelected();
    }

    public void setRootSelected(boolean selected) {
        this.root.setSelected(selected);
    }

    public void setIntervalSelected(String intervalSelected) {
        this.getIntervalItemsStream().filter(item -> intervalSelected.equals(this.formatInterval((Interval)item.getValue()))).forEach(item -> ((CheckBoxTreeItem)item).setSelected(true));
    }

    public boolean isIntervalSelected(Interval interval) {
        return this.getIntervalItemsStream().anyMatch(item -> interval.equals(item.getValue()) && ((CheckBoxTreeItem)item).isSelected());
    }

    private static class IntervalTreeItemComparator
    implements Comparator<TreeItem<Object>> {
        private IntervalTreeItemComparator() {
        }

        @Override
        public int compare(TreeItem<Object> o1, TreeItem<Object> o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            if (value1 instanceof Interval && value2 instanceof Interval) {
                return ((Interval)value1).getStart().compareTo(((Interval)value2).getStart());
            }
            return 0;
        }
    }
}

