/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelOverviewStrategy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DefaultExcelOverviewStrategy
extends ExcelOverviewStrategy<Orderbook> {
    public DefaultExcelOverviewStrategy(ApplicationContext ctx) {
        super(ctx);
    }

    @Override
    public List<List<Object>> consume(Orderbook orderbook) {
        ArrayList<List<Object>> result = Lists.newArrayList();
        ArrayList<Object> overviewData = new ArrayList<Object>();
        overviewData.add(orderbook.getExchange().getDisplayName());
        overviewData.add(orderbook.getDeliveryArea().getDisplayName());
        overviewData.add(orderbook.getContract().getName());
        overviewData.add(orderbook.getHi() != null ? this.localService.format(orderbook.getHi().getDisplayValue()) : null);
        overviewData.add(orderbook.getLow() != null ? this.localService.format(orderbook.getLow().getDisplayValue()) : null);
        overviewData.add(orderbook.getLastQuantity() != null ? this.localService.format(orderbook.getLastQuantity().getDisplayValue()) : null);
        overviewData.add(orderbook.getLastPrice() != null ? this.localService.format(orderbook.getLastPrice().getDisplayValue()) : null);
        overviewData.add(orderbook.getTradingPhase().getDisplayName());
        result.add(overviewData);
        return result;
    }
}

