/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.excel.ExcelStrategy;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;

public abstract class ExcelRowsStrategy<T, K>
implements ExcelStrategy<List<Object>, T> {
    final LocalService localService;
    final List<SingleRowProducer<K>> rowProducers;
    final DataModel<Long, Order> orderDataModel;

    public ExcelRowsStrategy(ApplicationContext ctx) {
        this.localService = ctx.getService(LocalService.class);
        this.orderDataModel = ctx.getDataModel(Order.class);
        this.rowProducers = Lists.newLinkedList();
    }

    protected void addProducers(SingleRowProducer<K> ... producers) {
        Arrays.stream(producers).forEach(this::addProducer);
    }

    protected void addProducer(SingleRowProducer<K> producer) {
        this.rowProducers.add(producer);
    }

    protected List<Object> processInOrder(List<K> entriesList, int i) {
        return this.process(entriesList, i, this.rowProducers);
    }

    protected List<Object> processInReverseOrder(List<K> entriesList, int i) {
        return this.process(entriesList, i, Lists.reverse(this.rowProducers));
    }

    private List<Object> process(List<K> entriesList, int i, List<SingleRowProducer<K>> rowProducers) {
        if (i < entriesList.size()) {
            Object entry = entriesList.get(i);
            return rowProducers.stream().reduce(Lists.newArrayList(), (list, producer) -> {
                list.add(producer.produce(entry));
                return list;
            }, (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            });
        }
        return this.createEmpty(rowProducers.size());
    }

    private List<Object> createEmpty(int nrOfNullsToAdd) {
        ArrayList<Object> nulls = Lists.newArrayList();
        IntStream.range(0, nrOfNullsToAdd).forEach(_1 -> nulls.add(null));
        return nulls;
    }

    @FunctionalInterface
    static interface SingleRowProducer<T> {
        public Object produce(T var1);
    }
}

