/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.flash;

import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.AnimationTimerColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.FlashDuration;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.ColorThemeService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;

@Singleton
public class ColorFlashFactoryImpl
implements ColorFlashFactory {
    private final SettingsService settingsService;
    private final ColorThemeService colorThemeService;
    private final ObjectProperty<FlashDuration> duration;
    private static final SettingsService.Settings<FlashDuration> FLASH_DURATION_SETTINGS = new SettingsService.Settings<FlashDuration>("flashDuration", DEFAULT_FLASH_DURATION);

    @Inject
    public ColorFlashFactoryImpl(ColorThemeService colorThemeService, SettingsService settingsService) {
        this.settingsService = settingsService;
        this.colorThemeService = colorThemeService;
        this.duration = new SimpleObjectProperty<FlashDuration>(this.getFlashDuration());
    }

    @Override
    public void storeFlashDuration(FlashDuration flashDuration) {
        this.duration.set(flashDuration);
        this.settingsService.storeSettings(FLASH_DURATION_SETTINGS, flashDuration);
    }

    @Override
    public FlashDuration getFlashDuration() {
        return this.settingsService.loadSettings(FLASH_DURATION_SETTINGS);
    }

    @Override
    public ColorFlash getFlash(Labeled labeled, ObservableValue<FlashDuration> duration) {
        return this.getFlash(labeled, duration::getValue);
    }

    @Override
    public ColorFlash getFlash(Labeled labeled) {
        return this.getFlash(labeled, this.duration::getValue);
    }

    private Color getColor() {
        return this.colorThemeService.getCurrentTheme().getFlashColor();
    }

    private ColorFlash getFlash(Labeled labeled, Supplier<FlashDuration> duration) {
        return new AnimationTimerColorFlash(labeled, duration, this::getColor);
    }
}

