/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;

public class ProgressCounter {
    private double progressStep;
    private final DoubleProperty currentProgress = new SimpleDoubleProperty(-1.0);
    private final BooleanProperty inProgress = new SimpleBooleanProperty(false);

    public ProgressCounter() {
        this.reset();
    }

    public void reset() {
        this.progressStep = 0.0;
        this.currentProgress.set(-1.0);
        this.inProgress.set(false);
    }

    public DoubleProperty currentProgressProperty() {
        return this.currentProgress;
    }

    public BooleanProperty inProgressProperty() {
        return this.inProgress;
    }

    public double getProgressStep() {
        return this.progressStep;
    }

    public void startNewProgress(int progressStepsNumber) {
        if (progressStepsNumber <= 0) {
            return;
        }
        this.currentProgress.set(0.0);
        this.progressStep = 1.0 / (double)progressStepsNumber;
        this.inProgress.set(true);
    }

    public void updateProgress() {
        if (this.inProgress.get()) {
            this.currentProgress.set(this.currentProgress.get() + this.progressStep);
            this.inProgress.set(this.currentProgress.get() + this.progressStep <= 1.0);
        }
    }
}

