/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import java.util.Collection;

public abstract class NotifyListenersObjectHandler<T>
implements ObjectHandler<T> {
    private BroadcastListenerHandlerForClass broadcastHandler;

    protected NotifyListenersObjectHandler(BroadcastListenerHandlerForClass broadcastHandler) {
        this.broadcastHandler = broadcastHandler;
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, T object, String correlationId) {
        Collection<BroadcastEntity> broadcastEntities = this.unpack(object, session.getExchange(), correlationId);
        if (broadcastEntities.size() == 1) {
            this.broadcastHandler.notifyListeners(broadcastEntities.iterator().next());
        } else if (broadcastEntities.size() > 1) {
            this.broadcastHandler.notifyListeners(broadcastEntities);
        }
        return ObjectHandler.Result.RETAIN;
    }

    public abstract Collection<? extends BroadcastEntity> unpack(T var1, Exchange var2, String var3);
}

