/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.comxerv;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.ProgressCounter;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeoutFactory;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutCleanUpDataModelEvent;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessResponseProcessor;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.ExchangeSpecificServiceLookup;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeServiceImpl
implements TradeService {
    private static final Logger LOG = LoggerFactory.getLogger(TradeServiceImpl.class);
    private final BackendConnectionGateway backendConnectionGateway;
    private final ExchangeSpecificServiceLookup serviceLookup;
    private final ObservableValue<Exchange> activeExchange;
    private final UserAlertService userAlertService;
    private final UserService userService;
    private final ExecutorService executorService;
    private final MessagePublisher messagePublisher;
    private final TradeProcessingUserInterface tradeProcessingUserInterface;
    private final ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory;
    private final ProgressCounter tradeCancellationProgress;
    private final Queue<TradeStateHolder> cancellationQueue;

    @Inject
    public TradeServiceImpl(ApplicationContext appContext) {
        this.backendConnectionGateway = appContext.getService(BackendConnectionGateway.class);
        this.serviceLookup = appContext.getService(ExchangeSpecificServiceLookup.class);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.userService = appContext.getService(UserService.class);
        this.executorService = appContext.getService(ExecutorService.class, SenderExecutor.class);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.tradeProcessingUserInterface = appContext.getService(TradeProcessingUserInterface.class);
        this.responseHandlerWithTimeoutFactory = appContext.getService(ResponseHandlerWithTimeoutFactory.class);
        this.tradeCancellationProgress = new ProgressCounter();
        this.tradeCancellationProgress.inProgressProperty().addListener(this.progressChangeListener());
        this.cancellationQueue = new ConcurrentLinkedQueue<TradeStateHolder>();
        appContext.getService(EventBus.class).register(this);
    }

    @Subscribe
    public void handleLogout(LogoutCleanUpDataModelEvent event) {
        this.clearTradeCancallationProgress();
    }

    private void clearTradeCancallationProgress() {
        this.cancellationQueue.clear();
        this.tradeCancellationProgress.reset();
    }

    private ChangeListener<? super Boolean> progressChangeListener() {
        return (observable2, oldValue, newValue) -> {
            if (BooleanUtils.isTrue(oldValue) && BooleanUtils.isFalse(newValue) && !this.cancellationQueue.isEmpty()) {
                TradeStateHolder tradeStateHolder = this.cancellationQueue.poll();
                this.handleTradeStateWithProgress(tradeStateHolder.trades(), tradeStateHolder.tradeState());
            }
        };
    }

    @Override
    public void processRecallTrades(List<FullTrade> trades) {
        this.tradeProcessingUserInterface.showTradesForProcessing(trades, TradeProcessingUserInterface.Mode.PROCESS, tradeState -> this.handleTradeState(trades, (TradeState)tradeState, new TradeProcessResponseProcessor.TradeRecallResponseProcessor()));
    }

    @Override
    public void cancelTrades(List<FullTrade> tradesToCancel) {
        List<FullTrade> trades = List.copyOf(tradesToCancel);
        this.tradeProcessingUserInterface.showTradesForProcessing(trades, TradeProcessingUserInterface.Mode.CANCEL, tradeState -> this.preHandleTradeState(trades, (TradeState)tradeState));
    }

    @Override
    public void recallTrades(List<? extends Trade> trades, ResponseHandler responseHandler) {
        if (this.userAlertService.showQuestionDialog(Util.getLabel("commons_recall"), Util.getLabel("tradesRecallPopup_question"), new UserAlertService.Flag[0])) {
            HashMap<Long, Trade> integerTradeMap = new HashMap<Long, Trade>();
            for (Trade trade : trades) {
                integerTradeMap.put(trade.getTradeId(), trade);
            }
            for (Trade trade : integerTradeMap.values()) {
                this.sendTraderRecall(trade, TradeState.RECALL_REQUESTED, responseHandler);
            }
        }
    }

    private void preHandleTradeState(List<FullTrade> trades, TradeState tradeState) {
        if (tradeState != null) {
            if (Boolean.TRUE.equals(this.tradeCancellationProgress.inProgressProperty().getValue())) {
                LOG.info("Putting {} trades to queue", (Object)trades.size());
                this.cancellationQueue.add(new TradeStateHolder(trades, tradeState));
            } else {
                this.handleTradeStateWithProgress(trades, tradeState);
            }
        }
    }

    private void handleTradeStateWithProgress(List<FullTrade> trades, TradeState tradeState) {
        this.tradeCancellationProgress.startNewProgress(trades.size());
        this.handleTradeState(trades, tradeState, new TradeProcessResponseProcessor.TradeCancelResponseProcessor(this.tradeProcessingUserInterface, trades));
    }

    private void handleTradeState(List<FullTrade> trades, TradeState tradeState, TradeProcessResponseProcessor tradeRespProcessor) {
        for (FullTrade trade : trades) {
            ResponseHandler responseHandler = response -> {
                this.handleTradeAdminRequestResponse(trade, tradeState, response);
                tradeRespProcessor.process(response);
                if (response.getStatus() != ResponseStatus.ACKNOWLEDGED) {
                    this.tradeCancellationProgress.updateProgress();
                }
            };
            if (tradeState == null) continue;
            this.sendTradeAdminRequest(trade, tradeState, true, false, responseHandler);
        }
    }

    private void handleTradeAdminRequestResponse(FullTrade trade, TradeState tradeState, AsyncResponse response) {
        if (ResponseStatus.ERROR.equals((Object)response.getStatus())) {
            boolean recallCapacity = true;
            boolean ignoreNegativeLimit = false;
            String question = null;
            String questionHeader = null;
            if (ErrorType.CAPACITY_NOT_RECALLED.equals((Object)response.getErrorType())) {
                question = Util.getLabel("tradeService_recallCapacity_question");
                questionHeader = Util.getLabel("commons_tradeRecallInformation");
                recallCapacity = false;
            } else if (ErrorType.EXCEED_TRADING_TIME.equals((Object)response.getErrorType())) {
                question = Util.getLabel("tradeService_cancelTradeInPredeliveryPhase_question");
                questionHeader = Util.getLabel("commons_cancelTradeInPredeliveryPhaseQuestion");
                recallCapacity = false;
            } else if (ErrorType.EXCEED_TRADING_TIME_AND_CAPACITY_NOT_RECALLED.equals((Object)response.getErrorType())) {
                question = Util.getLabel("tradeService_cancelCapacityOfXbTradeInPredeliveryPhase_question");
                questionHeader = Util.getLabel("commons_cancelTradeInPredeliveryPhaseQuestion");
                recallCapacity = false;
            } else if (ErrorType.NEGATIVE_LIMIT.equals((Object)response.getErrorType())) {
                question = Util.getLabel("tradeService_recallNegativeLimit_question");
                questionHeader = Util.getLabel("commons_tradeRecallConfirmation");
                ignoreNegativeLimit = true;
            }
            if (question != null && this.userAlertService.showQuestionDialog(questionHeader, question, new UserAlertService.Flag[0])) {
                this.sendTradeAdminRequest(trade, tradeState, recallCapacity, ignoreNegativeLimit, ResponseHandler.EMPTY);
            }
        } else if (ResponseStatus.SUCCESS.equals((Object)response.getStatus()) && tradeState == TradeState.CANCELLED) {
            this.messagePublisher.publishMessage(Util.getLabel("TRADE_CANCELLATION_SUCCESSFUL"), MessageSeverity.HIGH);
        }
    }

    @Override
    public boolean isTradeRecallProcessingPossible(List<FullTrade> trades) {
        if (CollectionUtils.isEmpty(trades) || !this.isModifyTrade()) {
            return false;
        }
        boolean isLocalExchange = this.activeExchange.getValue().getSystemInfo().isLocalExchange();
        return trades.stream().anyMatch(trade -> {
            switch (trade.getTradeState()) {
                case RECALL_REQUESTED: {
                    return trade.getRecallGrantedTime() == null || !isLocalExchange;
                }
                case CANCEL_REQUESTED: {
                    return !isLocalExchange;
                }
            }
            return false;
        });
    }

    @Override
    public boolean isTradeRecallPossible(List<HalfTrade> trades) {
        if (CollectionUtils.isEmpty(trades)) {
            return false;
        }
        return trades.stream().anyMatch(trade -> TradeState.ACTIVE == trade.getTradeState() && this.isOwnMemberTrade((HalfTrade)trade));
    }

    @Override
    public boolean isTradeCancellationPossible(List<FullTrade> trades) {
        if (CollectionUtils.isEmpty(trades) || !this.isModifyTrade()) {
            return false;
        }
        return trades.stream().map(Trade::getTradeState).anyMatch(state -> TradeState.ACTIVE.equals(state) || TradeState.RECALL_REJECTED.equals(state) || TradeState.RECALL_REQUESTED.equals(state));
    }

    private boolean isModifyTrade() {
        return Optional.ofNullable(this.userService.getOwnUser()).map(User::getRoles).map(UserRoles::isModifyTrade).orElse(false);
    }

    private void sendTradeAdminRequest(FullTrade trade, TradeState tradeState, boolean recallCapacity, boolean ignoreNegativeLimit, ResponseHandler responseHandler) {
        this.executorService.submit(() -> {
            ResponseHandler messagePublishingResponseHandler = responseHandler.chain(this.messagePublisher::publishMessage);
            TradeSubmitter submitter = this.serviceLookup.getExchangeSpecificService(TradeSubmitter.class, this.activeExchange.getValue());
            if (submitter == null) {
                LOG.error("No submitter found for exchange {}", (Object)this.activeExchange.getValue());
                messagePublishingResponseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null));
                return;
            }
            try {
                Request request = submitter.createTradeRequest(trade, tradeState, recallCapacity, ignoreNegativeLimit);
                this.sendRequestWithTimeout(messagePublishingResponseHandler, submitter, request);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating trade recall request.", e);
                submitter.processImmediateServerResponse(e, messagePublishingResponseHandler);
            }
        });
    }

    private void sendRequestWithTimeout(ResponseHandler responseHandler, TradeSubmitter submitter, Request request) {
        ExchangeConnection connection = this.backendConnectionGateway.getConnection();
        String correlationId = CorrelationId.next();
        ResponseHandlerWithTimeout responseHandlerWithTimeout = this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId);
        ObjectHandler<Object> objectHandler = this.getObjectHandler(submitter, correlationId, responseHandlerWithTimeout);
        connection.addObjectHandler(objectHandler);
        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
        ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
        this.processServerResponse(response, responseHandlerWithTimeout, submitter, connection, objectHandler);
    }

    private void processServerResponse(ResponseWithCorrelationId responseWithCorrelationId, ResponseHandler responseHandler, TradeSubmitter submitter, ExchangeConnection connection, ObjectHandler<Object> objectHandler) {
        boolean expectOtherMessages;
        if (responseWithCorrelationId.getResponse() != null && !(expectOtherMessages = submitter.processImmediateServerResponse(responseWithCorrelationId.getResponse(), responseHandler))) {
            connection.removeObjectHandler(objectHandler);
        }
    }

    private ObjectHandler<Object> getObjectHandler(TradeSubmitter submitter, String expectedCorrelationId, ResponseHandler responseHandler) {
        return (session, broadcastObject, correlationId) -> {
            if (expectedCorrelationId.equals(correlationId) && submitter.processAsyncServerResponse(broadcastObject, responseHandler)) {
                return ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    private void sendTraderRecall(Trade trade, TradeState tradeState, ResponseHandler responseHandler) {
        this.executorService.submit(() -> {
            TradeSubmitter submitter = this.serviceLookup.getExchangeSpecificService(TradeSubmitter.class, this.activeExchange.getValue());
            if (submitter == null) {
                LOG.error("No submitter found for exchange {}", (Object)this.activeExchange.getValue());
                return;
            }
            try {
                Request request = submitter.createTradeRequest(trade, tradeState, true, false);
                this.sendRequestWithTimeout(responseHandler, submitter, request);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating trade recall request.", e);
                responseHandler.handleGeneralError();
            }
        });
    }

    private boolean isOwnMemberTrade(HalfTrade trade) {
        return this.isTradeFromMemberOfUser(trade, this.userService.getCurrentUser());
    }

    @Override
    public boolean isOwnBgTrade(HalfTrade halfTrade) {
        return this.isTradeFromBgOfUser(halfTrade, this.userService.getCurrentUser());
    }

    @Override
    public boolean isOwnUserTrade(HalfTrade trade) {
        return this.isTradeFromOfUser(trade, this.userService.getCurrentUser());
    }

    @Override
    public ProgressCounter getTradeCancellationProgress() {
        return this.tradeCancellationProgress;
    }

    private boolean isTradeFromMemberOfUser(HalfTrade trade, User userForExchange) {
        return userForExchange.getMemberId().equals(trade.getMemberId());
    }

    private boolean isTradeFromOfUser(HalfTrade trade, User userForExchange) {
        return trade.getTraderId().equals(userForExchange.getUserCode());
    }

    private boolean isTradeFromBgOfUser(HalfTrade trade, User user) {
        return user.getBalancingGroupIds().contains(trade.getOrder().getBalancingGroupId());
    }

    @VisibleForTesting
    protected Queue<TradeStateHolder> getCancellationQueue() {
        return this.cancellationQueue;
    }

    private record TradeStateHolder(List<FullTrade> trades, TradeState tradeState) {
    }
}

