/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv;

import com.deutscheboerse.comxerv.comtrader.service.csv.ExportWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

public class ExportService {
    private final Writer writer;
    private final List<String> columnNames;
    private final List<List<Object>> preparedData;
    private final ExportWriter exportWriter;

    public ExportService(OutputStream outputStream, List<String> columnNames, List<List<Object>> preparedData, ExportWriter exportWriter) {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.columnNames = columnNames;
        this.preparedData = preparedData;
        this.exportWriter = exportWriter;
    }

    public void exportData() throws IOException {
        this.exportWriter.writeHeader(this.writer, this.columnNames);
        for (List<Object> dataLine : this.preparedData) {
            this.exportWriter.writeDataLine(this.writer, dataLine);
        }
        this.exportWriter.writeFooter(this.writer);
        this.writer.flush();
    }
}

