/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.service.csv.ExportWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousExportService
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousExportService.class);
    private final Writer writer;
    private final ExportWriter exportWriter;
    private final ScheduledExecutorService scheduledExecutorService;
    private boolean flushPending = false;
    private static final int BUFF_SIZE_1MB = 0x100000;

    public ContinuousExportService(File file, ExportWriter exportWriter, ScheduledExecutorService scheduledExecutorService) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)), 0x100000);
        this.exportWriter = exportWriter;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public synchronized void writeHeaders(String name, List<String> columnNames) throws IOException {
        this.exportWriter.writeHeader(this.writer, Arrays.asList(name));
        this.exportWriter.writeHeader(this.writer, null);
        this.exportWriter.writeHeader(this.writer, columnNames);
        this.writer.flush();
    }

    public synchronized void appendDataLine(List<Object> dataLine) throws IOException {
        this.exportWriter.writeDataLine(this.writer, dataLine);
        if (!this.flushPending) {
            this.flushPending = true;
            this.scheduledExecutorService.schedule(this::flushAsync, 1L, TimeUnit.SECONDS);
        }
    }

    private synchronized void flushAsync() {
        try {
            this.flushPending = false;
            this.writer.flush();
        }
        catch (Exception e) {
            LOG.error("Error during continuous export flush.", e);
        }
    }

    public synchronized void appendDataLineWithoutFlush(List<Object> dataLine) throws IOException {
        this.exportWriter.writeDataLine(this.writer, dataLine);
    }

    public synchronized void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

