/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.DeliveryAreaQueries;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.EntityColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ExportColumn;

public abstract class DeliveryAreaColumn<E>
extends EntityColumn<DeliveryArea>
implements ExportColumn<DeliveryArea, E> {
    private final DeliveryAreaQueries deliveryAreaQueries;

    public DeliveryAreaColumn(String header, ApplicationContext applicationContext) {
        super(header, DeliveryArea.class, applicationContext);
        this.deliveryAreaQueries = applicationContext.getService(DeliveryAreaQueries.class);
    }

    public DeliveryArea parseDeliveryAreaValue(String data) {
        return this.deliveryAreaQueries.findByName(data).getFirst().orElse(null);
    }

    @Override
    public String getStringValue(DeliveryArea value) {
        return value.getName();
    }

    @Override
    public boolean isMandatory(Exchange exchange) {
        return exchange.supportsDeliveryAreas();
    }
}

