/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractService;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ContractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderRearContractColumn
extends ContractColumn<Order>
implements ImportColumn<Contract, Order> {
    private final BlockContractService blockContractService;

    public OrderRearContractColumn(String header, ApplicationContext appContext) {
        super(header, appContext);
        this.blockContractService = appContext.getService(BlockContractService.class);
    }

    @Override
    public Contract getValue(Order objectToExport) {
        return objectToExport.getContract();
    }

    @Override
    public Contract parseValue(String data) throws ImportException {
        Contract contract = this.parseContractValue(data);
        if (contract != null || data.isEmpty()) {
            return contract;
        }
        throw new ImportException("Unknown rear contract.", Util.getLabel("orderValidationError_invalidRearContract") + " " + data);
    }

    @Override
    public void applyValue(Contract value, Order order) throws ImportException {
        Contract frontContract = order.getContract();
        if (!this.blockContractService.isValidBlockContractSide(frontContract)) {
            throw new ImportException("Invalid front contract.", Util.getLabel("orderValidationError_invalidFrontContract") + " " + frontContract.getName());
        }
        Contract rearContract = value;
        if (!this.blockContractService.isValidBlockContractSide(rearContract)) {
            throw new ImportException("Invalid rear contract.", Util.getLabel("orderValidationError_invalidRearContract") + " " + rearContract.getName());
        }
        if (!this.blockContractService.isFrontAndRearContractConsistent(frontContract, rearContract)) {
            throw new ImportException("Inconsistent front and rear contract", Util.getLabel("orderValidationError_inconsistentFrontAndRearContract") + " " + frontContract.getName() + ", " + rearContract.getName());
        }
        Contract blockContract = this.blockContractService.createBlockContract(frontContract, rearContract, this.blockContractService.getBlockProduct(frontContract.getProduct())).orElse(null);
        order.setContract(blockContract);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_CONTRACT.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INACTIVE_CONTRACT.getMessageKey());
    }
}

