/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ContinuousExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.trade.ContinuousTradePrepareExportService;
import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityAdditionalLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContinuousExportTradeListener
extends AbstractDataModelListener<FullTrade>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousExportTradeListener.class);
    private final ContinuousExportService continuousExportService;
    private final ContinuousTradePrepareExportService continuousTradePrepareExportService;
    private final ExecutorService executorService;
    private final EventBus eventBus;
    private final LargePersistableDataModel<Long, FullTrade> dataModel;
    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private final SortedSet<HalfTrade> initialTradesBuffer = new TreeSet<HalfTrade>(new HalfTradeExportComparator());

    protected ContinuousExportTradeListener(ApplicationContext appContext, ContinuousExportService continuousExportService) {
        this.continuousExportService = continuousExportService;
        this.continuousTradePrepareExportService = appContext.getService(ContinuousTradePrepareExportService.class);
        this.executorService = appContext.getService(ExecutorService.class, WorkerExecutor.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.eventBus.register(this);
        this.dataModel = appContext.getLargeDataModel(FullTrade.class);
        this.initializationStarted();
        this.dataModel.registerHencePostOperationListener(this);
        this.executorService.submit(this::finishInitialization);
    }

    public synchronized void finishInitialization() {
        this.dataModel.foreach(this::notifyAdd);
        this.exportInitialTrades();
    }

    private synchronized void initializationStarted() {
        this.initializing.set(true);
    }

    private void exportOrBuffer(FullTrade trade) {
        trade.allHalfTrades().forEach(this::exportOrBuffer);
    }

    private synchronized void exportOrBuffer(HalfTrade trade) {
        if (this.initializing.get()) {
            this.initialTradesBuffer.remove(trade);
            this.initialTradesBuffer.add(trade);
        } else if (trade.isDirty()) {
            this.exportTradeAsynchronously(trade);
        }
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(FullTrade trade) {
        this.exportOrBuffer(trade);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyAdd(FullTrade trade) {
        this.exportOrBuffer(trade);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemove(FullTrade trade) {
        if (!TradeState.ACTIVE.equals(trade.getTradeState())) {
            this.exportOrBuffer(trade);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private synchronized void exportInitialTrades() {
        if (!this.initialTradesBuffer.isEmpty()) {
            LOG.info("Initial trades export started with buffer size {}", (Object)this.initialTradesBuffer.size());
            for (HalfTrade dataItem : this.initialTradesBuffer) {
                try {
                    this.exportInitialTrade(dataItem);
                }
                catch (Exception e) {
                    LOG.error("Error while writing trade export.", e);
                    this.handleExportError(e);
                }
            }
            this.continuousExportService.flush();
            this.initialTradesBuffer.clear();
        }
        this.initializing.set(false);
        LOG.info("Initial trades export finished.");
    }

    private void exportTradeAsynchronously(HalfTrade trade) {
        HalfTrade copiedTrade = new HalfTrade(trade);
        this.executorService.submit(() -> {
            try {
                this.exportTrade(copiedTrade);
            }
            catch (Exception e) {
                LOG.error("Error while writing trade export.", e);
                this.handleExportError(e);
            }
        });
    }

    private synchronized void exportTrade(HalfTrade trade) throws IOException {
        if (this.isTradeInScope(trade)) {
            List<Object> exportedDataItem = this.continuousTradePrepareExportService.getExportedDataItem(trade);
            this.continuousExportService.appendDataLine(exportedDataItem);
        }
    }

    private void exportInitialTrade(HalfTrade trade) throws IOException {
        if (this.isTradeInScope(trade)) {
            List<Object> exportedDataItem = this.continuousTradePrepareExportService.getExportedDataItem(trade);
            this.continuousExportService.appendDataLineWithoutFlush(exportedDataItem);
        }
    }

    @Subscribe
    public void handleInitialLoadingStarted(EntityLoadingStartedEvent<FullTrade> event) {
        if (event.getEntityClass().equals(FullTrade.class)) {
            this.initializationStarted();
        }
    }

    @Subscribe
    public void handleAllLoadingFinished(EntityAdditionalLoadingFinishedEvent<FullTrade> event) {
        if (event.getEntityClass().equals(FullTrade.class)) {
            this.executorService.submit(this::exportInitialTrades);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.continuousExportService.close();
        this.eventBus.unregister(this);
        this.dataModel.unregisterListener(this);
        LOG.info("ContinuousExportService outputStream successfully closed");
    }

    @Subscribe
    public synchronized void handleApplicationShutdown(ApplicationShutdownEvent applicationShutdownEvent) {
        try {
            this.continuousExportService.close();
        }
        catch (Exception e) {
            LOG.error("continuousExportService outputStream could not be closed", e);
        }
    }

    public abstract void handleExportError(Exception var1);

    public abstract boolean isTradeInScope(HalfTrade var1);

    private static final class HalfTradeExportComparator
    implements Comparator<HalfTrade> {
        private HalfTradeExportComparator() {
        }

        @Override
        public int compare(HalfTrade o1, HalfTrade o2) {
            int exchangeComparison = ((Long)o1.getId()).compareTo((Long)o2.getId());
            if (exchangeComparison != 0) {
                return exchangeComparison;
            }
            int tradeIdComparison = o1.getTradeId().compareTo(o2.getTradeId());
            if (tradeIdComparison != 0) {
                return tradeIdComparison;
            }
            return o1.getOrder().getId().compareTo(o2.getOrder().getId());
        }
    }
}

