/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OrdersToSend {
    private final List<Order> orders;
    private final RequestType requestType;
    private final BasketRestriction basketRestriction;
    private final ResponseHandler responseHandler;
    private final User onBehalfUser;

    public OrdersToSend(Collection<Order> orders, RequestType requestType, ResponseHandler responseHandler) {
        this(orders, requestType, null, responseHandler, null);
    }

    public OrdersToSend(Order order, RequestType requestType) {
        this(order, requestType, ResponseHandler.EMPTY, null);
    }

    public OrdersToSend(Order order, RequestType requestType, ResponseHandler responseHandler) {
        this(Collections.singletonList(order), requestType, null, responseHandler, null);
    }

    public OrdersToSend(Order order, RequestType requestType, ResponseHandler responseHandler, User onBehalfUser) {
        this(Collections.singletonList(order), requestType, null, responseHandler, onBehalfUser);
    }

    public OrdersToSend(Collection<Order> orders, RequestType requestType, BasketRestriction basketRestriction, ResponseHandler responseHandler, User onBehalfUser) {
        this.orders = new ArrayList<Order>(orders);
        this.requestType = requestType;
        this.basketRestriction = basketRestriction;
        this.responseHandler = responseHandler;
        this.onBehalfUser = onBehalfUser;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public BasketRestriction getBasketRestriction() {
        return this.basketRestriction;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public User getOnBehalfUser() {
        return this.onBehalfUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrdersToSend that = (OrdersToSend)o;
        return Objects.equals(this.orders, that.orders) && this.requestType == that.requestType && this.basketRestriction == that.basketRestriction && Objects.equals(this.responseHandler, that.responseHandler) && Objects.equals(this.onBehalfUser, that.onBehalfUser);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orders, this.requestType, this.basketRestriction, this.responseHandler, this.onBehalfUser});
    }
}

