/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry.validation;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidator;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.SimpleValidationResult;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMode;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.collections4.CollectionUtils;

public class CommonOrderValidationService
implements OrderValidationService {
    private final ApplicationContext applicationContext;
    private Exchange lastExchange;
    private OrderValidator orderValidator;

    private static OrderValidationService.ValidationResult getInvalidExchangeResult() {
        return new SimpleValidationResult(ValidationFlag.INVALID, ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_EXCHANGE, Collections.emptyList());
    }

    @Inject
    public CommonOrderValidationService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public OrderValidationService.ValidationResult validateOrder(Order order, ValidationMode mode) {
        return this.getValidator().map(orderValidator -> orderValidator.validateOrder(order, mode)).orElseGet(CommonOrderValidationService::getInvalidExchangeResult);
    }

    @Override
    public ReadOnlyBooleanProperty isOrderBasketableProperty(ObservableValue<Order> order) {
        SimpleBooleanProperty result = new SimpleBooleanProperty(false);
        final ReadOnlyObjectProperty<OrderValidationService.ValidationResult> validationResultProperty = this.validationResultProperty(order);
        result.bind((ObservableValue<? extends Boolean>)new DependentBinding<Boolean>(this, new Observable[]{validationResultProperty}){
            private final Set<ValidationFlag> BASKETABLE_FLAGS;
            {
                super(arg0);
                this.BASKETABLE_FLAGS = Sets.newHashSet(ValidationFlag.BASKET, ValidationFlag.SUBMIT);
            }

            @Override
            protected Boolean computeValue() {
                return this.BASKETABLE_FLAGS.contains((Object)((OrderValidationService.ValidationResult)validationResultProperty.get()).getResult());
            }
        });
        return result;
    }

    @Override
    public ReadOnlyBooleanProperty isOrderSubmittableProperty(ObservableValue<Order> order) {
        SimpleBooleanProperty result = new SimpleBooleanProperty(false);
        final ReadOnlyObjectProperty<OrderValidationService.ValidationResult> validationResultProperty = this.validationResultProperty(order);
        result.bind((ObservableValue<? extends Boolean>)new DependentBinding<Boolean>(this, new Observable[]{validationResultProperty}){

            @Override
            protected Boolean computeValue() {
                return ValidationFlag.SUBMIT.equals((Object)((OrderValidationService.ValidationResult)validationResultProperty.get()).getResult());
            }
        });
        return result;
    }

    @Override
    public ReadOnlyObjectProperty<OrderValidationService.ValidationResult> validationResultProperty(ObservableValue<Order> order) {
        SimpleObjectProperty<OrderValidationService.ValidationResult> result = new SimpleObjectProperty<OrderValidationService.ValidationResult>();
        InvalidationListener invalidationListener = observable2 -> {
            result.unbind();
            Optional<OrderValidator> validator = this.getValidator();
            if (validator.isPresent()) {
                result.bind(validator.get().validationResultProperty((Order)order.getValue()));
            } else {
                result.setValue(CommonOrderValidationService.getInvalidExchangeResult());
            }
        };
        order.addListener(invalidationListener);
        order.getValue().contractProperty().addListener(invalidationListener);
        invalidationListener.invalidated(null);
        return result;
    }

    private Optional<OrderValidator> getValidator() {
        Exchange currentExchange = this.applicationContext.getService(ActiveExchange.class).getActiveExchange().get();
        if (currentExchange != this.lastExchange) {
            this.orderValidator = currentExchange == null ? null : this.applicationContext.getService(OrderValidator.class, currentExchange);
            this.lastExchange = currentExchange;
        }
        return Optional.ofNullable(this.orderValidator);
    }

    @Override
    public String getValidationErrorsString(OrderValidationService.ValidationResult validationResult) {
        StringBuilder errorsText = new StringBuilder();
        if (validationResult != null) {
            for (String key : validationResult.getLocalizedErrorMessageKeys()) {
                if (errorsText.length() > 0) {
                    errorsText.append("\n");
                }
                errorsText.append(Util.getLabel(key, validationResult.getParameters(key)));
            }
        }
        return errorsText.toString();
    }

    @Override
    public boolean canBeActivated(List<Order> orders) {
        if (CollectionUtils.isEmpty(orders)) {
            return false;
        }
        if (!orders.stream().filter(Objects::nonNull).map(Order::getStatus).allMatch(OrderStatus.HIBERNATE::equals)) {
            return false;
        }
        return orders.stream().filter(Objects::nonNull).allMatch(this::orderCanBeActivated);
    }

    private boolean orderCanBeActivated(Order order) {
        return this.validateOrder(order, ValidationMode.ORDERENTRY).getResult() == ValidationFlag.SUBMIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeDeactivated(List<Order> orders) {
        if (!CollectionUtils.isNotEmpty(orders)) return false;
        if (!orders.stream().filter(Objects::nonNull).map(Order::getStatus).allMatch(OrderStatus.ACTIVE::equals)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeDeleted(List<Order> orders) {
        if (!CollectionUtils.isNotEmpty(orders)) return false;
        if (!orders.stream().filter(Objects::nonNull).map(Order::getStatus).noneMatch(OrderStatus.ERROR::equals)) return false;
        return true;
    }

    public static enum ValidationFlag {
        INVALID,
        SUBMIT,
        BASKET;

    }
}

