/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.performancemonitoring;

import ch.qos.logback.classic.Level;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.FramerateMonitor;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceLoggingService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PerformanceLoggingServiceImpl
implements PerformanceLoggingService {
    private final MessagePublisher messagePublisher;
    private final FramerateMonitor framerateMonitor;
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceLoggingService.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");

    @Inject
    public PerformanceLoggingServiceImpl(MessagePublisher messagePublisher, FramerateMonitor framerateMonitor) {
        this.messagePublisher = messagePublisher;
        this.framerateMonitor = framerateMonitor;
    }

    @Override
    public void togglePerformanceLogging() {
        if (this.isEnabled()) {
            this.disable();
        } else {
            this.enable();
        }
    }

    private void enable() {
        ((ch.qos.logback.classic.Logger)PERFORMANCE_LOG).setLevel(Level.DEBUG);
        String message = Util.getLabel("feedback_message_performance_logging_enabled");
        LOG.info(message);
        this.messagePublisher.publishMessage(message, MessageSeverity.LOW);
        this.framerateMonitor.enable();
    }

    private void disable() {
        ((ch.qos.logback.classic.Logger)PERFORMANCE_LOG).setLevel(Level.ERROR);
        String message = Util.getLabel("feedback_message_performance_logging_disabled");
        LOG.info(message);
        this.messagePublisher.publishMessage(message, MessageSeverity.LOW);
        this.framerateMonitor.disable();
    }

    private boolean isEnabled() {
        return PERFORMANCE_LOG.isDebugEnabled();
    }
}

