/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.performancemonitoring;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceStatisticsLog;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceStatisticsService;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.RequestClassifier;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.m7.comtrader.remote.log.v2.LogService;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.Client;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.RequestDuration;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Singleton
public class PerformanceStatisticsServiceImpl
implements PerformanceStatisticsService {
    private volatile PerformanceStatisticsLog log;
    private final BackendConnectionGateway backendConnectionGateway;
    private final TimeService timeService;
    private final ApplicationContext applicationContext;
    private final SecureRandom random;
    private final ScheduledExecutorService scheduledExecutorService;
    private final LogService logService;
    private final ApplicationConfigurationService configurationService;

    @Inject
    public PerformanceStatisticsServiceImpl(ApplicationContext applicationContext, SecureRandom random) {
        this.applicationContext = applicationContext;
        this.random = random;
        this.timeService = applicationContext.getService(TimeService.class);
        this.scheduledExecutorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.logService = applicationContext.getService(LogService.class);
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.configurationService = applicationContext.getService(ApplicationConfigurationService.class);
        if (this.configurationService.getBooleanApplicationProperty("perf.stats.enabled")) {
            applicationContext.getService(EventBus.class).register(this);
            this.scheduleLogUploading();
        }
    }

    private void scheduleLogUploading() {
        Integer intervalInSeconds = this.configurationService.getIntegerApplicationProperty("perf.stats.intervalInSeconds", 3600);
        Integer maxDelayInSeconds = this.configurationService.getIntegerApplicationProperty("perf.stats.maxUploadDelayInSeconds", 900);
        this.scheduledExecutorService.schedule(this::collectAndSend, (long)intervalInSeconds.intValue() + (long)this.random.nextInt(maxDelayInSeconds), TimeUnit.SECONDS);
    }

    @Override
    public void recordRequest(String correlationId, Object request) {
        this.getLogForSession().handleRequest(correlationId, request);
    }

    @Override
    public void recordResponse(String correlationId, Object response, Long pmiProcessingTime) {
        this.getLogForSession().handleResponse(correlationId, null, response, pmiProcessingTime);
    }

    @Override
    public void recordBroadcast(String correlationId, Long eventIndex, Object broadcast) {
        this.getLogForSession().handleBroadcast(correlationId, eventIndex, broadcast);
    }

    private PerformanceStatisticsLog getLogForSession() {
        Session session = this.backendConnectionGateway.getSession();
        if (this.log != null) {
            return this.log;
        }
        if (session != null) {
            this.log = this.createLog(session);
            return this.log;
        }
        throw new IllegalStateException();
    }

    protected void collectAndSend() {
        if (this.log != null) {
            this.scheduledExecutorService.execute(() -> this.collectAndSend(this.log));
        }
        this.scheduleLogUploading();
    }

    private void collectAndSend(PerformanceStatisticsLog log) {
        List<RequestDuration> requests = log.collectAllExceptPending();
        Client client = log.getClient();
        this.sendLogRecord(client, requests);
    }

    private void sendLogRecord(Client client, List<RequestDuration> requests) {
        if (!requests.isEmpty()) {
            this.logService.store(client, requests);
        }
    }

    private PerformanceStatisticsLog createLog(Session session) {
        RequestClassifier requestClassifier = this.applicationContext.getService(RequestClassifier.class, session.getExchange());
        return new PerformanceStatisticsLog(this.timeService, requestClassifier, session);
    }

    @Subscribe
    public void handleLogout(LogoutEvent logoutEvent) {
        if (logoutEvent.isSendStatistics()) {
            this.collectAndSend();
        }
    }
}

