/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.version;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.version.NormalizedVersion;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionMismatchAlertService;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VersionServiceImpl
implements VersionService {
    private static final Logger LOG = LoggerFactory.getLogger(VersionServiceImpl.class);
    private final String version;
    private final String buildts;
    private final NormalizedVersion normalizedVersion;
    private final VersionMismatchAlertService alertService;
    private final InvalidationListener exchangesChanged;
    private final ObservableValue<Exchange> activeExchange;

    @Inject
    public VersionServiceImpl(ApplicationContext appContext) {
        this(appContext, Util.getLabel("application_version"));
    }

    public VersionServiceImpl(ApplicationContext appContext, String version) {
        this.alertService = appContext.getService(VersionMismatchAlertService.class);
        this.exchangesChanged = observable2 -> this.checkVersions();
        this.version = version;
        this.buildts = appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("comtrader.buildts");
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.activeExchange.addListener(new WeakInvalidationListener(this.exchangesChanged));
        this.normalizedVersion = new NormalizedVersion(version);
        if (this.normalizedVersion.getElements().isEmpty()) {
            LOG.warn("Strange version number. The resulting normalized version is empty. {}", (Object)version);
        }
        this.checkVersions();
    }

    private void checkVersions() {
        NormalizedVersion versionFromBackend;
        Exchange value = this.activeExchange.getValue();
        if (value != null && this.normalizedVersion.compareTo(versionFromBackend = new NormalizedVersion(value.getSystemInfo().getCurrentComtraderVersion())) < 0) {
            this.alertService.showVersionMismatchWarning(this.normalizedVersion.toString(), versionFromBackend.toString());
        }
    }

    @Override
    public String getComtraderTS() {
        return this.buildts;
    }

    @Override
    public String getComtraderVersion() {
        return this.version;
    }

    @Override
    public NormalizedVersion getNormalizedComtraderVersion() {
        return this.normalizedVersion;
    }

    @Override
    public Runtime.Version getJavaVersion() {
        return Runtime.version();
    }
}

