/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecificCommon;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.spi.Message;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExchangeSpecificServiceLookup {
    public static final Logger LOG = LoggerFactory.getLogger(ExchangeSpecificServiceLookup.class);
    private final Injector injector;

    @Inject
    public ExchangeSpecificServiceLookup(Injector injector) {
        this.injector = injector;
    }

    public <T> T getExchangeSpecificService(Class<T> serviceClass, Exchange exchange) {
        try {
            return this.getInstance(serviceClass, exchange);
        }
        catch (RuntimeException e) {
            LOG.error("Error when retrieving service: " + serviceClass.getName() + " " + String.valueOf(exchange), e);
            throw e;
        }
    }

    private <T> T getInstance(Class<T> serviceClass, Exchange exchange) {
        try {
            return this.injector.getInstance(Key.get(serviceClass, (Annotation)new ForExchange(exchange)));
        }
        catch (ConfigurationException e) {
            return this.injector.getInstance(Key.get(serviceClass));
        }
    }

    protected static class ForExchange
    extends ExchangeSpecificCommon {
        private final String apiVersion;

        protected ForExchange(Exchange exchange) {
            if (exchange == null) {
                throw new ConfigurationException(Set.of(new Message("Exchange not specified")));
            }
            this.apiVersion = exchange.getApiVersion();
        }

        @Override
        public String apiVersion() {
            return this.apiVersion;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

