/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlFormatterUtil {
    public static final Logger LOG = LoggerFactory.getLogger(XmlFormatterUtil.class);

    private XmlFormatterUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static String formatXML(String unformattedXml) {
        String string;
        block9: {
            StreamSource streamSource = new StreamSource(new StringReader(unformattedXml));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("indent-number", 2);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.transform(streamSource, xmlOutput);
            Writer writer = xmlOutput.getWriter();
            try {
                string = writer.toString();
                if (writer == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TransformerException e) {
                    LOG.error("XML formatter error", e);
                    return "Error thrown from XML formatter: " + e.getMessage() + "\nUnformatted XML: " + unformattedXml;
                }
                catch (IOException e) {
                    LOG.error("XML formatter io error", e);
                    return "Error thrown from XML formatter: " + e.getMessage() + "\nUnformatted XML: " + unformattedXml;
                }
            }
            writer.close();
        }
        return string;
    }
}

