/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.type;

import com.deutscheboerse.m7.trading.api.type.ProductType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public enum ProductConfigurationConstants {
    ISIN("isin", true, false),
    ISIN_VALUE("isinValue", true, null, String.class),
    BLOCK_ORDER("blockOrderProduct", true, true, ProductType.COMMODITY),
    BLOCK_MAXIMUM_DELIVERY_UNITS("blockMaximumDeliveryUnits", false, 30, ProductType.USER_DEFINED_DELIVERY),
    DST_BLOCK_TRADING("dstBlockProduct", true, false, ProductType.ENERGY),
    CROSS_BORDER("crossBorderProduct", true, false),
    ICEBERG_ORDER("icebergOrderProduct", true, false),
    ICEBERG_MIN_PEAK_SIZE("icebergMinPeakSize", true, null, Integer.class),
    ICEBERG_PRICE_DELTA_RANGE("icebergPriceDeltaRange", true, null, Integer.class),
    STOP_ORDER("stopOrderProduct", true, false),
    INDICATIVE_ORDER("indicativeOrderProduct", true, false),
    LINKED_ORDER("linkedOrderProduct", true, false),
    QUOTE_ORDER("quoteOrderProduct", true, false),
    QUOTE_MIN_QUANTITY("quoteMinQuantity", true, null, Integer.class),
    OTC_ALLOWED("otcAllowed", true, true),
    OTC_ONLY("otcOnly", true, false),
    ON_EXCHANGE_PREARRANGED_TRADE("onExchangePrearrangedTrade", true, false),
    PRIVATE_AND_CONFIDENTIAL("privateAndConfidential", true, false),
    COMMODITY_LIMIT("commodityLimitEnabled", false, false),
    INTRA_PRODUCT_SPREADS("intraProductSpreads", true, false),
    INTRA_PRODUCT_SPREADS_CONTRACT_COUNT("intraProductSpreadsContractCount", true, 2),
    IS_WITHIN_DELIVERY("productIsWithinDelivery", false, false, ProductType.COMMODITY),
    LEAD_TIME("leadTime", false, 4, ProductType.COMMODITY),
    AUTO_ORDER_MATCHER("autoOrderMatcher", true, true),
    LIFT_ORDER_MATCHER("liftOrderMatcher", true, false),
    CLEARING_HOUSES("clgHouses", true, false),
    PRODUCT_COMMODITY_ID("productCommodityId", false, null, String.class),
    CROSS_PRODUCT_MATCHING("crossProductMatchingEnabled", true, false),
    TRADE_DECOMPOSITION("tradeDecomposition", true, false),
    AUTO_ORDER_TRANSFER("aotEnabled", true, false, ProductType.COMMODITY);

    private final String key;
    private final boolean defaultPropagate;
    private final String defaultValue;
    private final ProductType productType;
    private final Class clazz;

    private ProductConfigurationConstants(String key, boolean defaultPropagate, String defaultValue, ProductType productType, Class clazz) {
        this.key = key;
        this.defaultPropagate = defaultPropagate;
        this.defaultValue = defaultValue;
        this.productType = productType;
        this.clazz = clazz;
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, String defaultValue, Class clazz) {
        this(key, defaultPropagate, defaultValue, null, clazz);
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, int defaultValue, ProductType productType) {
        this(key, defaultPropagate, Integer.toString(defaultValue), productType, Integer.class);
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, int defaultValue) {
        this(key, defaultPropagate, Integer.toString(defaultValue), null, Integer.class);
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, long defaultValue) {
        this(key, defaultPropagate, Long.toString(defaultValue), null, Long.class);
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, boolean defaultValue, ProductType productType) {
        this(key, defaultPropagate, Boolean.toString(defaultValue), productType, Boolean.class);
    }

    private ProductConfigurationConstants(String key, boolean defaultPropagate, boolean defaultValue) {
        this(key, defaultPropagate, Boolean.toString(defaultValue), null, Boolean.class);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isDefaultPropagate() {
        return this.defaultPropagate;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public static ProductConfigurationConstants valueOfByKey(String key) {
        List<ProductConfigurationConstants> allValues = Arrays.asList(ProductConfigurationConstants.values());
        return allValues.stream().filter(constant -> constant.getKey().equals(key)).findFirst().orElse(null);
    }

    public static Collection<ProductConfigurationConstants> defaultPropagateValues() {
        List<ProductConfigurationConstants> allValues = Arrays.asList(ProductConfigurationConstants.values());
        return allValues.stream().filter(ProductConfigurationConstants::isDefaultPropagate).collect(Collectors.toList());
    }
}

