/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control;

import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import com.deutscheboerse.ui.jfx.util.control.ListViewPopup;
import com.deutscheboerse.ui.jfx.util.control.PopupWidth;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class AutoCompleteTextField<T>
extends TextField {
    private final ListView<String> suggestionsListView;
    private final ListViewPopup<String> popup;
    private static final int SUGGESTION_LIST_VISIBLE_ROWS = 4;
    private static final double DEFAULT_MIN_WIDTH = 100.0;
    protected final ValidProperty valid = new ValidProperty(this);
    private final DependentBinding<Number> listViewHeight;
    private Function<T, String> toStringConverter = Object::toString;

    protected AutoCompleteTextField(String noItemsAvailableLabelText) {
        this.suggestionsListView = new ListView();
        this.suggestionsListView.setId("suggestionListView");
        this.suggestionsListView.setItems(FXCollections.observableArrayList());
        this.suggestionsListView.setFocusTraversable(false);
        this.listViewHeight = DependentBinding.get(fixedCellSize -> fixedCellSize.doubleValue() * 4.0, this.suggestionsListView.fixedCellSizeProperty());
        this.suggestionsListView.prefHeightProperty().bind(this.listViewHeight);
        this.suggestionsListView.maxHeightProperty().bind(this.listViewHeight);
        this.suggestionsListView.setPlaceholder(new Label(noItemsAvailableLabelText));
        this.popup = new ListViewPopup<String>(this, this.suggestionsListView);
        this.suggestionsListView.getSelectionModel().selectedIndexProperty().addListener(this::selectedSuggestionIndexChanged);
        this.popup.setHideOnEscape(true);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this::handleMouseEvent);
        this.addEventFilter(KeyEvent.KEY_PRESSED, this::onTextFieldKeyPressed);
        this.suggestionsListView.setOnMouseClicked(this::onSuggestionsListViewMouseClicked);
        this.focusedProperty().addListener(this::onFocusChanged);
        this.textProperty().addListener(observable2 -> this.reloadSuggestions());
        this.setMinWidth(100.0);
        StyleUtil.addStyleClasses(this.suggestionsListView, "popupListView");
    }

    private void selectedSuggestionIndexChanged(ObservableValue<? extends Number> observable2, Number oldValue, Number newValue) {
        int index = newValue.intValue();
        if (index >= 0) {
            this.suggestionsListView.scrollTo(index);
        }
    }

    protected abstract Stream<T> getSuggestions();

    private void handleMouseEvent(MouseEvent mouseEvent) {
        if (!this.popup.isShowing()) {
            this.showPopup();
        }
    }

    private void onFocusChanged(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
        if (!oldValue.booleanValue() && newValue.booleanValue()) {
            this.showPopup();
        }
        if (oldValue.booleanValue() && !newValue.booleanValue()) {
            this.popup.hide();
        }
    }

    private void showPopup() {
        this.reloadSuggestions();
        if (!this.suggestionsListView.getItems().isEmpty() && this.isEditable() && this.getScene() != null && this.getScene().getWindow() != null && !this.popup.isShowing()) {
            this.popup.showPopup();
        }
    }

    private void onSuggestionsListViewMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            this.setSelectedText(mouseEvent);
        }
    }

    private void onTextFieldKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.UP) {
            this.suggestionsListView.getSelectionModel().selectPrevious();
            keyEvent.consume();
        } else if (keyEvent.getCode() == KeyCode.DOWN) {
            this.suggestionsListView.getSelectionModel().selectNext();
            keyEvent.consume();
        } else if (keyEvent.getCode() == KeyCode.ENTER) {
            if (this.popup.isShowing()) {
                this.setSelectedText(keyEvent);
                keyEvent.consume();
            }
        } else if (keyEvent.getCode() == KeyCode.TAB) {
            this.setSelectedText(keyEvent);
        } else {
            this.showPopup();
        }
    }

    private void reloadSuggestions() {
        List<String> suggestions = this.getSuggestions().map(this.toStringConverter).distinct().toList();
        this.suggestionsListView.getItems().setAll((Collection<String>)suggestions);
    }

    private void setSelectedText(Event event) {
        String selectedItem = (String)this.suggestionsListView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.setText(selectedItem);
            this.positionCaret(this.getText().length());
            event.consume();
        }
        this.popup.hide();
    }

    public void setPopupWidth(PopupWidth popupWidth) {
        this.popup.setPopupWidth(popupWidth);
    }

    public ObjectProperty<PopupWidth> popupWidthProperty() {
        return this.popup.popupWidthProperty();
    }

    public PopupWidth getPopupWidth() {
        return this.popup.getPopupWidth();
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid.set(valid);
    }

    public Function<T, String> getToStringConverter() {
        return this.toStringConverter;
    }

    public void setToStringConverter(Function<T, String> toStringConverter) {
        this.toStringConverter = toStringConverter;
    }

    protected static class ToStringConverterComparator<T>
    implements Comparator<T> {
        private final Function<T, String> toStringConverter;

        public ToStringConverterComparator(Function<T, String> toStringConverter) {
            this.toStringConverter = toStringConverter;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.toStringConverter.apply(o1).compareTo(this.toStringConverter.apply(o2));
        }
    }
}

