/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.Transformer;

public class InvokerTransformer<T, R>
implements Transformer<T, R> {
    private final String iMethodName;
    private final Class<?>[] iParamTypes;
    private final Object[] iArgs;

    public static <I, O> Transformer<I, O> invokerTransformer(String methodName) {
        return new InvokerTransformer(Objects.requireNonNull(methodName, "methodName"));
    }

    public static <I, O> Transformer<I, O> invokerTransformer(String methodName, Class<?>[] paramTypes, Object[] args2) {
        Objects.requireNonNull(methodName, "methodName");
        if (paramTypes == null && args2 != null || paramTypes != null && args2 == null || paramTypes != null && args2 != null && paramTypes.length != args2.length) {
            throw new IllegalArgumentException("The parameter types must match the arguments");
        }
        if (paramTypes == null || paramTypes.length == 0) {
            return new InvokerTransformer(methodName);
        }
        return new InvokerTransformer(methodName, paramTypes, args2);
    }

    private InvokerTransformer(String methodName) {
        this.iMethodName = methodName;
        this.iParamTypes = null;
        this.iArgs = null;
    }

    public InvokerTransformer(String methodName, Class<?>[] paramTypes, Object[] args2) {
        this.iMethodName = methodName;
        this.iParamTypes = paramTypes != null ? (Class[])paramTypes.clone() : null;
        this.iArgs = args2 != null ? (Object[])args2.clone() : null;
    }

    @Override
    public R transform(Object input) {
        if (input == null) {
            return null;
        }
        try {
            Class<?> cls = input.getClass();
            Method method = cls.getMethod(this.iMethodName, this.iParamTypes);
            return (R)method.invoke(input, this.iArgs);
        }
        catch (NoSuchMethodException ex) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' does not exist");
        }
        catch (IllegalAccessException ex) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' cannot be accessed");
        }
        catch (InvocationTargetException ex) {
            throw new FunctorException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' threw an exception", ex);
        }
    }
}

