/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.auth;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.auth.HttpAuthHeader;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;

public class DigestAuthSupplier
implements HttpAuthSupplier {
    Map<URI, DigestInfo> authInfo = new ConcurrentHashMap<URI, DigestInfo>();

    @Override
    public boolean requiresRequestCaching() {
        return true;
    }

    @Override
    public String getAuthorization(AuthorizationPolicy authPolicy, URI currentURI, Message message, String fullHeader) {
        Map<String, String> map;
        if (authPolicy == null || authPolicy.getUserName() == null && authPolicy.getPassword() == null) {
            return null;
        }
        if (fullHeader == null) {
            DigestInfo di = this.authInfo.get(currentURI);
            if (di != null) {
                return di.generateAuth(DigestAuthSupplier.getAuthURI(currentURI), authPolicy.getUserName(), authPolicy.getPassword());
            }
            return null;
        }
        HttpAuthHeader authHeader = new HttpAuthHeader(fullHeader);
        if (authHeader.authTypeIsDigest() && ("auth".equals((map = authHeader.getParams()).get("qop")) || !map.containsKey("qop"))) {
            DigestInfo di = new DigestInfo();
            di.qop = map.get("qop");
            di.realm = map.get("realm");
            di.nonce = map.get("nonce");
            di.opaque = map.get("opaque");
            if (map.containsKey("algorithm")) {
                di.algorithm = map.get("algorithm");
            }
            if (map.containsKey("charset")) {
                di.charset = map.get("charset");
            }
            di.method = (String)message.get("org.apache.cxf.request.method");
            if (di.method == null) {
                di.method = "POST";
            }
            this.authInfo.put(currentURI, di);
            return di.generateAuth(DigestAuthSupplier.getAuthURI(currentURI), authPolicy.getUserName(), authPolicy.getPassword());
        }
        return null;
    }

    private static String getAuthURI(URI currentURI) {
        Object authURI = currentURI.getRawPath();
        if (currentURI.getRawQuery() != null) {
            authURI = (String)authURI + "?" + currentURI.getRawQuery();
        }
        return authURI;
    }

    public String createCnonce() {
        return Long.toString(System.currentTimeMillis());
    }

    class DigestInfo {
        String qop;
        String realm;
        String nonce;
        String opaque;
        int nc;
        String algorithm = "MD5";
        String charset = "ISO-8859-1";
        String method = "POST";

        DigestInfo() {
        }

        synchronized String generateAuth(String uri, String username, String password) {
            try {
                String serverDigestValue;
                String ncstring;
                String digAlg = this.algorithm;
                if ("MD5-sess".equalsIgnoreCase(digAlg)) {
                    digAlg = "MD5";
                }
                MessageDigest digester = MessageDigest.getInstance(digAlg);
                String cnonce = DigestAuthSupplier.this.createCnonce();
                String a1 = username + ":" + this.realm + ":" + password;
                if ("MD5-sess".equalsIgnoreCase(this.algorithm)) {
                    String tmp2 = StringUtils.toHexString(digester.digest(a1.getBytes(this.charset)));
                    a1 = tmp2 + ":" + this.nonce + ":" + cnonce;
                }
                String hasha1 = StringUtils.toHexString(digester.digest(a1.getBytes(this.charset)));
                String a2 = this.method + ":" + uri;
                String hasha2 = StringUtils.toHexString(digester.digest(a2.getBytes(StandardCharsets.US_ASCII)));
                if (this.qop == null) {
                    ncstring = null;
                    serverDigestValue = hasha1 + ":" + this.nonce + ":" + hasha2;
                } else {
                    ncstring = StringUtils.toHexString(ByteBuffer.allocate(4).putInt(++this.nc).array());
                    serverDigestValue = hasha1 + ":" + this.nonce + ":" + ncstring + ":" + cnonce + ":" + this.qop + ":" + hasha2;
                }
                String response = StringUtils.toHexString(digester.digest(serverDigestValue.getBytes(StandardCharsets.US_ASCII)));
                HashMap<String, String> outParams = new HashMap<String, String>();
                if (this.qop != null) {
                    outParams.put("qop", "auth");
                }
                outParams.put("realm", this.realm);
                outParams.put("opaque", this.opaque);
                outParams.put("nonce", this.nonce);
                outParams.put("uri", uri);
                outParams.put("username", username);
                if (ncstring != null) {
                    outParams.put("nc", ncstring);
                }
                outParams.put("cnonce", cnonce);
                outParams.put("response", response);
                outParams.put("algorithm", this.algorithm);
                return new HttpAuthHeader("Digest", outParams).getFullHeader();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

