/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.CharLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.CharLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.factory.primitive.CharLongMaps;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.CharLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableCharLongSingletonMap
implements ImmutableCharLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final char key1;
    private final long value1;

    ImmutableCharLongSingletonMap(char key1, long value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public long get(char key) {
        return this.getIfAbsent(key, 0L);
    }

    @Override
    public long getIfAbsent(char key, long ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public long getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(long value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(CharLongProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public boolean allSatisfyKeyValue(CharLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    @Override
    public LazyCharIterable keysView() {
        return CharLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<CharLongPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableLongCharMap flipUniqueValues() {
        return LongCharMaps.immutable.with(this.value1, this.key1);
    }

    @Override
    public ImmutableCharLongMap select(CharLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharLongHashMap().toImmutable();
    }

    @Override
    public ImmutableCharLongMap reject(CharLongPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharLongHashMap().toImmutable() : CharLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with(LongBags.immutable.with(this.value1));
    }

    @Override
    public ImmutableCharLongMap toImmutable() {
        return this;
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(CharLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    @Override
    public void each(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(LongPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public long min() {
        return this.value1;
    }

    @Override
    public long max() {
        return this.value1;
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.value1;
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public long[] toSortedArray() {
        return new long[]{this.value1};
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableLongBag select(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongHashBag.newBagWith(this.value1).toImmutable() : LongBags.immutable.empty();
    }

    @Override
    public ImmutableLongBag reject(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongBags.immutable.empty() : LongHashBag.newBagWith(this.value1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public long[] toArray() {
        return new long[]{this.value1};
    }

    @Override
    public long[] toArray(long[] target) {
        if (target.length < 1) {
            target = new long[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    @Override
    public boolean contains(long value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator2 = source.longIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableLongList toList() {
        return LongArrayList.newListWith(this.value1);
    }

    @Override
    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public ImmutableCharLongMap newWithKeyValue(char key, long value) {
        return CharLongMaps.immutable.withAll(CharLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableCharLongMap newWithoutKey(char key) {
        return this.key1 == key ? CharLongMaps.immutable.with() : this;
    }

    @Override
    public ImmutableCharLongMap newWithoutAllKeys(CharIterable keys2) {
        return keys2.contains(this.key1) ? CharLongMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(CharHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(LongArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharLongMap)) {
            return false;
        }
        CharLongMap map = (CharLongMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ (int)(this.value1 ^ this.value1 >>> 32);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

