/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;

public class TextExt
extends Text {
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;
    private final StyleableObjectProperty<Paint> backgroundColor = new CustomStyleableProperty<Paint>(null, "backgroundColor", this, StyleableProperties.BACKGROUND_COLOR);
    private final StyleableObjectProperty<Paint> borderStrokeColor = new CustomStyleableProperty<Paint>(null, "borderStrokeColor", this, StyleableProperties.BORDER_COLOR);
    private final StyleableObjectProperty<Number> borderStrokeWidth = new CustomStyleableProperty<Number>(null, "borderStrokeWidth", this, StyleableProperties.BORDER_WIDTH);
    private final StyleableObjectProperty<StrokeType> borderStrokeType = new CustomStyleableProperty<StrokeType>(null, "borderStrokeType", this, StyleableProperties.BORDER_TYPE);
    private final StyleableObjectProperty<Number[]> borderStrokeDashArray = new CustomStyleableProperty<Number[]>(null, "borderStrokeDashArray", this, StyleableProperties.BORDER_DASH_ARRAY);
    private final StyleableObjectProperty<Paint> underlineColor = new CustomStyleableProperty<Paint>(null, "underlineColor", this, StyleableProperties.UNDERLINE_COLOR);
    private final StyleableObjectProperty<Number> underlineWidth = new CustomStyleableProperty<Number>(null, "underlineWidth", this, StyleableProperties.UNDERLINE_WIDTH);
    private final StyleableObjectProperty<Number> underlineOffset = new CustomStyleableProperty<Number>(null, "underlineOffset", this, StyleableProperties.UNDERLINE_OFFSET);
    private final StyleableObjectProperty<Number> underlineWaveRadius = new CustomStyleableProperty<Number>(null, "underlineWaveRadius", this, StyleableProperties.UNDERLINE_WAVE_RADIUS);
    private final StyleableObjectProperty<Number[]> underlineDashArray = new CustomStyleableProperty<Number[]>(null, "underlineDashArray", this, StyleableProperties.UNDERLINE_DASH_ARRAY);
    private final StyleableObjectProperty<Number> underlineDoubleGap = new CustomStyleableProperty<Number>(null, "underlineDoubleGap", this, StyleableProperties.UNDERLINE_DOUBLE_GAP);
    private final StyleableObjectProperty<StrokeLineCap> underlineCap = new CustomStyleableProperty<StrokeLineCap>(null, "underlineCap", this, StyleableProperties.UNDERLINE_CAP);

    public TextExt(String text) {
        super(text);
    }

    public TextExt() {
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public Paint getBackgroundColor() {
        return (Paint)this.backgroundColor.get();
    }

    public void setBackgroundColor(Paint fill) {
        this.backgroundColor.set(fill);
    }

    public ObjectProperty<Paint> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Paint getBorderStrokeColor() {
        return (Paint)this.borderStrokeColor.get();
    }

    public void setBorderStrokeColor(Paint fill) {
        this.borderStrokeColor.set(fill);
    }

    public ObjectProperty<Paint> borderStrokeColorProperty() {
        return this.borderStrokeColor;
    }

    public Number getBorderStrokeWidth() {
        return (Number)this.borderStrokeWidth.get();
    }

    public void setBorderStrokeWidth(Number width) {
        this.borderStrokeWidth.set(width);
    }

    public ObjectProperty<Number> borderStrokeWidthProperty() {
        return this.borderStrokeWidth;
    }

    public StrokeType getBorderStrokeType() {
        return (StrokeType)((Object)this.borderStrokeType.get());
    }

    public void setBorderStrokeType(StrokeType type) {
        this.borderStrokeType.set(type);
    }

    public ObjectProperty<StrokeType> borderStrokeTypeProperty() {
        return this.borderStrokeType;
    }

    public Number[] getBorderStrokeDashArray() {
        return (Number[])this.borderStrokeDashArray.get();
    }

    public void setBorderStrokeDashArray(Number[] array) {
        this.borderStrokeDashArray.set(array);
    }

    public ObjectProperty<Number[]> borderStrokeDashArrayProperty() {
        return this.borderStrokeDashArray;
    }

    public Paint getUnderlineColor() {
        return (Paint)this.underlineColor.get();
    }

    public void setUnderlineColor(Paint fill) {
        this.underlineColor.set(fill);
    }

    public ObjectProperty<Paint> underlineColorProperty() {
        return this.underlineColor;
    }

    public Number getUnderlineWidth() {
        return (Number)this.underlineWidth.get();
    }

    public void setUnderlineWidth(Number width) {
        this.underlineWidth.set(width);
    }

    public ObjectProperty<Number> underlineWidthProperty() {
        return this.underlineWidth;
    }

    public Number getUnderlineOffset() {
        return (Number)this.underlineOffset.get();
    }

    public void setUnderlineOffset(Number width) {
        this.underlineOffset.set(width);
    }

    public ObjectProperty<Number> underlineOffsetProperty() {
        return this.underlineOffset;
    }

    public Number getUnderlineWaveRadius() {
        return (Number)this.underlineWaveRadius.get();
    }

    public void setUnderlineWaveRadius(Number radius) {
        this.underlineWaveRadius.set(radius);
    }

    public ObjectProperty<Number> underlineWaveRadiusProperty() {
        return this.underlineWaveRadius;
    }

    public Number getUnderlineDoubleGap() {
        return (Number)this.underlineDoubleGap.get();
    }

    public void setUnderlineDoubleGap(Number radius) {
        this.underlineDoubleGap.set(radius);
    }

    public ObjectProperty<Number> underlineDoubleGapProperty() {
        return this.underlineDoubleGap;
    }

    public Number[] getUnderlineDashArray() {
        return (Number[])this.underlineDashArray.get();
    }

    public void setUnderlineDashArray(Number[] dashArray) {
        this.underlineDashArray.set(dashArray);
    }

    public ObjectProperty<Number[]> underlineDashArrayProperty() {
        return this.underlineDashArray;
    }

    public StrokeLineCap getUnderlineCap() {
        return (StrokeLineCap)((Object)this.underlineCap.get());
    }

    public void setUnderlineCap(StrokeLineCap cap) {
        this.underlineCap.set(cap);
    }

    public ObjectProperty<StrokeLineCap> underlineCapProperty() {
        return this.underlineCap;
    }

    static {
        ArrayList styleables = new ArrayList(Text.getClassCssMetaData());
        styleables.add(StyleableProperties.BACKGROUND_COLOR);
        styleables.add(StyleableProperties.BORDER_COLOR);
        styleables.add(StyleableProperties.BORDER_WIDTH);
        styleables.add(StyleableProperties.BORDER_TYPE);
        styleables.add(StyleableProperties.BORDER_DASH_ARRAY);
        styleables.add(StyleableProperties.UNDERLINE_COLOR);
        styleables.add(StyleableProperties.UNDERLINE_WIDTH);
        styleables.add(StyleableProperties.UNDERLINE_OFFSET);
        styleables.add(StyleableProperties.UNDERLINE_WAVE_RADIUS);
        styleables.add(StyleableProperties.UNDERLINE_DASH_ARRAY);
        styleables.add(StyleableProperties.UNDERLINE_DOUBLE_GAP);
        styleables.add(StyleableProperties.UNDERLINE_CAP);
        CSS_META_DATA_LIST = Collections.unmodifiableList(styleables);
    }

    private static class StyleableProperties {
        private static final CssMetaData<TextExt, Paint> BACKGROUND_COLOR = new CustomCssMetaData<TextExt, Color>("-rtfx-background-color", StyleConverter.getPaintConverter(), Color.TRANSPARENT, n -> n.backgroundColor);
        private static final CssMetaData<TextExt, Paint> BORDER_COLOR = new CustomCssMetaData<TextExt, Color>("-rtfx-border-stroke-color", StyleConverter.getPaintConverter(), Color.TRANSPARENT, n -> n.borderStrokeColor);
        private static final CssMetaData<TextExt, Number> BORDER_WIDTH = new CustomCssMetaData<TextExt, Integer>("-rtfx-border-stroke-width", StyleConverter.getSizeConverter(), Integer.valueOf(0), n -> n.borderStrokeWidth);
        private static final CssMetaData<TextExt, StrokeType> BORDER_TYPE = new CustomCssMetaData<TextExt, StrokeType>("-rtfx-border-stroke-type", StyleConverter.getEnumConverter(StrokeType.class), StrokeType.INSIDE, n -> n.borderStrokeType);
        private static final CssMetaData<TextExt, Number[]> BORDER_DASH_ARRAY = new CustomCssMetaData<TextExt, Double[]>("-rtfx-border-stroke-dash-array", SizeConverter.SequenceConverter.getInstance(), new Double[0], n -> n.borderStrokeDashArray);
        private static final CssMetaData<TextExt, Paint> UNDERLINE_COLOR = new CustomCssMetaData<TextExt, Color>("-rtfx-underline-color", StyleConverter.getPaintConverter(), Color.TRANSPARENT, n -> n.underlineColor);
        private static final CssMetaData<TextExt, Number> UNDERLINE_WIDTH = new CustomCssMetaData<TextExt, Integer>("-rtfx-underline-width", StyleConverter.getSizeConverter(), Integer.valueOf(0), n -> n.underlineWidth);
        private static final CssMetaData<TextExt, Number> UNDERLINE_OFFSET = new CustomCssMetaData<TextExt, Integer>("-rtfx-underline-offset", StyleConverter.getSizeConverter(), Integer.valueOf(0), n -> n.underlineOffset);
        private static final CssMetaData<TextExt, Number> UNDERLINE_WAVE_RADIUS = new CustomCssMetaData<TextExt, Integer>("-rtfx-underline-wave-radius", StyleConverter.getSizeConverter(), Integer.valueOf(0), n -> n.underlineWaveRadius);
        private static final CssMetaData<TextExt, Number[]> UNDERLINE_DASH_ARRAY = new CustomCssMetaData<TextExt, Double[]>("-rtfx-underline-dash-array", SizeConverter.SequenceConverter.getInstance(), new Double[0], n -> n.underlineDashArray);
        private static final CssMetaData<TextExt, Number> UNDERLINE_DOUBLE_GAP = new CustomCssMetaData<TextExt, Integer>("-rtfx-underline-double-gap", StyleConverter.getSizeConverter(), Integer.valueOf(0), n -> n.underlineDoubleGap);
        private static final CssMetaData<TextExt, StrokeLineCap> UNDERLINE_CAP = new CustomCssMetaData<TextExt, StrokeLineCap>("-rtfx-underline-cap", StyleConverter.getEnumConverter(StrokeLineCap.class), StrokeLineCap.SQUARE, n -> n.underlineCap);

        private StyleableProperties() {
        }
    }
}

