/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadTask;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadSystemInfoTask
extends LoadTask {
    private static final Logger LOG = LoggerFactory.getLogger(LoadSystemInfoTask.class);

    public LoadSystemInfoTask(ComXervLoadContext loadContext) {
        super(loadContext);
    }

    @Override
    public void run() {
        try {
            AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
            if (connection != null) {
                Exchange exchange = this.getLoadContext().getExchange();
                SystemInfo systemInfo = connection.getSystemInfo();
                exchange.updateSystemInfo(systemInfo);
                LOG.info("Systeminfo loaded: {}, {}", (Object)systemInfo.getBackendVersion(), (Object)systemInfo.getTimeZone());
                this.getLoadContext().getAppContext().getService(TimeService.class).updateServerTimeZone(systemInfo.getTimeZone());
            }
        }
        catch (RuntimeException e) {
            this.getLoadContext().loadingError(e, SystemInfo.class);
        }
    }
}

