/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.AdditionalAsyncLoadTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.AdditionalTradesLoadingFinishedTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.FinalizeTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.FireEntityLoadingFinishedTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.FireEntityLoadingStartedTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.InitializeTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadBalancingGroupsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadCommodityTradingLimitsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadDeliveryAreasTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadHistoricalTradeSettlementsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadHistoricalTradesTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadHubToHubTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadMarketAreasTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadMarketStateTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadMembersTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadMessagesTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadOrderLimitsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadOrderbooksTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadOrdersTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadProductsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadPublicTradeConfirmationsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadRecentTradeSettlementsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadRecentTradesTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadRemoteMarketAreasTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadRiskSetsTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSystemInfoTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadTradingLimitTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadUsersTask;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.WaitForFxThreadTask;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.InitialLoadingService;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.ForkJoin;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.Sequence;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedTask;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.joda.time.Interval;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervInitialLoadingService
implements InitialLoadingService {
    @Inject
    private ApplicationContext appContext;
    private volatile ComXervLoadContext loadContext;

    @Override
    public void doInitialLoad(Exchange exchange) {
        this.loadContext = new ComXervLoadContext(this.appContext, exchange);
        ExecutorService executorService = this.appContext.getService(ExecutorService.class, SenderExecutor.class);
        Executor executor = executorService::submit;
        executor.execute(new Sequence(new InitializeTask(this.loadContext), new LoadSystemInfoTask(this.loadContext), new LoadMarketAreasTask(this.loadContext), new LoadRiskSetsTask(this.loadContext), new AdditionalAsyncLoadTask(this.loadContext, executor, new Sequence(new LoadRemoteMarketAreasTask(this.loadContext), new LoadHubToHubTask(this.loadContext, executor))), new ForkJoin(executor, new LoadMarketStateTask(this.loadContext), new LoadDeliveryAreasTask(this.loadContext), new LoadProductsTask(this.loadContext), new LoadTradingLimitTask(this.loadContext), new LoadMembersTask(this.loadContext), new LoadBalancingGroupsTask(this.loadContext)), new WaitForFxThreadTask(this.loadContext), new ForkJoin(executor, new LoadUsersTask(this.loadContext), new LoadContracts(this.loadContext, executor), new LoadOrderLimitsTask(this.loadContext)), new WaitForFxThreadTask(this.loadContext), new LoadOrdersTask(this.loadContext), new WaitForFxThreadTask(this.loadContext), new FireEntityLoadingStartedTask(this.loadContext, Orderbook.class), new ForkJoin(executor, new LoadCommodityTradingLimitsTask(this.loadContext), new LoadOrderbooksTask(this.loadContext), new LoadReferencePrices(this.loadContext), new LoadRecentTradesTask(this.loadContext), new LoadPublicTradeConfirmationsTask(this.loadContext), new LoadMessagesTask(this.loadContext)), new WaitForFxThreadTask(this.loadContext), new FireEntityLoadingFinishedTask(this.loadContext, Orderbook.class), new FinalizeTask(this.loadContext), new AdditionalAsyncLoadTask(this.loadContext, executor, new Sequence(new LoadRecentTradeSettlementsTask(this.loadContext), new LoadHistoricalTradesTask(this.loadContext), new LoadHistoricalTradeSettlementsTask(this.loadContext), new AdditionalTradesLoadingFinishedTask(this.loadContext)))));
    }

    private static final class LoadContracts
    extends LoadSingleEntityTypeTask<Contract> {
        private final Executor executor;

        public LoadContracts(ComXervLoadContext loadContext, Executor executor) {
            super(loadContext, Contract.class);
            this.executor = executor;
        }

        @Override
        protected Set<Contract> load() {
            final HashSet<Contract> result = new HashSet<Contract>();
            final ComXervExchangeConnection connection = (ComXervExchangeConnection)this.getLoadContext().getConnection();
            if (connection != null) {
                final Set products = this.getLoadContext().getAll(Product.class).collect(Collectors.toSet());
                List<Interval> intervals = this.getLoadContext().getTimeSlicesForContracts();
                new SlicedTask<Interval, Set<Contract>>(this, "Load Contracts", this.executor, intervals){

                    @Override
                    protected Set<Contract> runSlowAsyncPart(Interval interval) {
                        return connection.getContracts(products, interval.getStart(), interval.getEnd());
                    }

                    @Override
                    protected void runFastSyncPart(Set<Contract> contracts) {
                        result.addAll(contracts);
                    }
                }.run();
            }
            return result;
        }
    }

    private static final class LoadReferencePrices
    extends LoadSingleEntityTypeTask<Orderbook> {
        public LoadReferencePrices(ComXervLoadContext loadContext) {
            super(loadContext, Orderbook.class, false);
        }

        @Override
        protected Set<Orderbook> load() {
            HashSet<Orderbook> result = new HashSet<Orderbook>();
            ComXervExchangeConnection connection = (ComXervExchangeConnection)this.getLoadContext().getConnection();
            if (connection != null) {
                result.addAll(connection.getReferencePrices());
            }
            return result;
        }
    }
}

