/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.ExchangeSpecific;
import com.deutscheboerse.comxerv.comtrader.domain.query.PublicTradeConfirmationQueries;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.PublicTradeConfirmationService;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Singleton
@ExchangeSpecific(apiVersion="v6")
public class ComXervPublicTradeConfirmationService
implements PublicTradeConfirmationService {
    private Interval requestedInterval;
    private volatile ComXervLoadContext comXervLoadContext;
    private ApplicationContext applicationContext;
    private final Duration dataLoadingIntervalDuration;

    @Inject
    public ComXervPublicTradeConfirmationService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.applicationContext.getService(EventBus.class).register(this);
        this.dataLoadingIntervalDuration = Duration.standardHours(applicationContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty("dataLoadingIntervalSplitHours", 24).intValue());
    }

    @Subscribe
    public void loadingFinishedEvent(LoadingFinishedEvent loadingFinishedEvent) {
        this.comXervLoadContext = new ComXervLoadContext(this.applicationContext, loadingFinishedEvent.getSession().getExchange());
        DateTime timeOfOldestPublicTradeConfirmation = this.applicationContext.getService(PublicTradeConfirmationQueries.class).getTimeOfOldestPublicTradeConfirmation();
        DateTime serverTime = this.applicationContext.getService(TimeService.class).getServerTime();
        this.requestedInterval = new Interval((ReadableInstant)(timeOfOldestPublicTradeConfirmation == null ? serverTime.minusHours(4) : timeOfOldestPublicTradeConfirmation), (ReadableInstant)serverTime);
    }

    @Override
    public void loadPublicTradesTill(DateTime startTime) {
        if (this.requestedInterval.isAfter(startTime)) {
            this.applicationContext.getService(EventBus.class).post(new EntityLoadingStartedEvent<PublicTradeConfirmation>(PublicTradeConfirmation.class));
            ExecutorService executorService = this.applicationContext.getService(ExecutorService.class, WorkerExecutor.class);
            CompletableFuture[] futures = (CompletableFuture[])DateTimeUtils.split(startTime, this.requestedInterval.getStart(), this.dataLoadingIntervalDuration).stream().map(this::loadSlice).map(runnable -> CompletableFuture.runAsync(runnable, executorService)).toArray(CompletableFuture[]::new);
            ((CompletableFuture)CompletableFuture.allOf(futures).thenApply(unused -> () -> {
                this.requestedInterval = new Interval((ReadableInstant)startTime, (ReadableInstant)this.requestedInterval.getEnd());
                this.comXervLoadContext.handleEntities(PublicTradeConfirmation.class, Collections.emptySet(), true);
            })).thenAccept(executorService::execute);
        }
    }

    private Runnable loadSlice(Interval interval) {
        return () -> {
            Set<PublicTradeConfirmation> load = this.load(interval.getStart(), interval.getEnd());
            this.comXervLoadContext.handleEntities(PublicTradeConfirmation.class, load, false);
        };
    }

    Set<PublicTradeConfirmation> load(DateTime startTime, DateTime endTime) {
        HashSet<PublicTradeConfirmation> result = new HashSet<PublicTradeConfirmation>();
        UserRoles userRoles = this.comXervLoadContext.getUserRoles();
        boolean hasProperRole = userRoles.isDataVendor() || userRoles.isTrader() || userRoles.isSalesUser() || userRoles.isAdmin() || userRoles.isBroker();
        AbstractComXervExchangeConnection connection = this.comXervLoadContext.getConnection();
        if (connection != null && hasProperRole) {
            result.addAll(connection.getPublicTradeConfirmation(startTime, endTime));
        }
        return result;
    }
}

