/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.listener.MapperAwareNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.m7.trading.api.v6.AccountType;
import com.deutscheboerse.m7.trading.api.v6.AcctInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.PblcAccountBaseType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class AcctInfoRprtNotifyListenerObjectHandler
extends MapperAwareNotifyListenerObjectHandler<AcctInfoRprt> {
    private final AbstractComXervExchangeConnection connection;
    private final OnBehalfService onBehalfService;
    private final UserService userService;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;

    public AcctInfoRprtNotifyListenerObjectHandler(BroadcastListenerHandlerForClass broadcastHandler, MapperHandler mappers, AbstractComXervExchangeConnection connection, ApplicationContext applicationContext) {
        super(broadcastHandler, mappers);
        this.connection = connection;
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
        this.userService = applicationContext.getService(UserService.class);
        this.balancingGroupDataModel = applicationContext.getDataModel(BalancingGroup.class);
    }

    @Override
    public Collection<BalancingGroup> unpack(AcctInfoRprt acctInfoRprt, Exchange exchange, String correlationId) {
        if (acctInfoRprt.getAcctList() != null) {
            return this.mappers.translateSet(BalancingGroup.class, acctInfoRprt.getAcctList().getAcct());
        }
        return Collections.emptySet();
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, AcctInfoRprt acctInfoRprt, String correlationId) {
        boolean productOrDAAssignmentChanged;
        Set<String> currentUserBallancingGroups = this.userService.getOwnUser().getBalancingGroupIds();
        boolean bl = productOrDAAssignmentChanged = acctInfoRprt.getAcctList() != null && acctInfoRprt.getAcctList().getAcct().stream().filter(accountType -> currentUserBallancingGroups.contains(accountType.getAcctId())).anyMatch(this::wasProductOrDAAssignmentForBGChanged);
        if (productOrDAAssignmentChanged) {
            this.connection.forceFullDataReload();
        } else {
            super.handleObject(session, acctInfoRprt, correlationId);
            User onBehalfUser = this.onBehalfService.getOnBehalfUser();
            if (onBehalfUser != null && acctInfoRprt.getAcctList() != null) {
                boolean bgOfOnBehalfUserChanged = acctInfoRprt.getAcctList().getAcct().stream().map(PblcAccountBaseType::getAcctId).anyMatch(onBehalfUser.getBalancingGroupIds()::contains);
                if (bgOfOnBehalfUserChanged) {
                    this.onBehalfService.reloadOnBehalfUser();
                }
            }
        }
        return ObjectHandler.Result.RETAIN;
    }

    private boolean wasProductOrDAAssignmentForBGChanged(AccountType accountType) {
        List<String> receivedProducts;
        BalancingGroup balancingGroup = this.balancingGroupDataModel.findById(accountType.getAcctId());
        if (balancingGroup == null) {
            return false;
        }
        Set<String> assignedProducts = balancingGroup.getProductIds();
        boolean productAssignmentChanged = !assignedProducts.containsAll(receivedProducts = accountType.getProdName()) || !receivedProducts.containsAll(assignedProducts);
        Set<String> assignedDAs = balancingGroup.getDeliveryAreaIds();
        List<String> receivedDAs = accountType.getDlvryAreaId();
        boolean daAssignmentChanged = !assignedDAs.containsAll(receivedDAs) || !receivedDAs.containsAll(assignedDAs);
        return productAssignmentChanged || daAssignmentChanged;
    }
}

