/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.type.LimitType;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradingLimitState;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.CashLmtRprt;
import com.deutscheboerse.m7.trading.api.v6.CashLmtRprtType;
import com.deutscheboerse.m7.trading.api.v6.CashLmtStateType;
import org.joda.time.DateTimeZone;

public class TradingLimitMapper
extends AbstractMapper<CashLmtRprtType, TradingLimit> {
    public TradingLimitMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, CashLmtRprtType.class, TradingLimit.class);
    }

    @Override
    public TradingLimit translate(CashLmtRprtType from, MapperHandler mapperHandler, Object hint) {
        TradingLimit tradingLimit = new TradingLimit();
        tradingLimit.setLimitType(LimitType.CASH);
        tradingLimit.setMemberId(((CashLmtRprt)hint).getMbrId());
        tradingLimit.setInitial(new LongDisplayValue(from.getCashLmt(), from.getDecShft()));
        tradingLimit.setRevisionNumber(from.getRevisionNo());
        DateTimeZone timeZone = this.getExchange().getSystemInfo().getTimeZone();
        tradingLimit.setStartDate(DateTimeUtils.mapDateToLocalDate(from.getStartDate(), timeZone));
        tradingLimit.setEndDate(DateTimeUtils.mapDateToLocalDate(from.getEndDate(), timeZone));
        tradingLimit.setState(this.mapTradingLimitState(from.getState()));
        tradingLimit.setId(String.valueOf(from.getLmtId()));
        tradingLimit.setCurrency(from.getCurrency());
        return tradingLimit;
    }

    protected TradingLimitState mapTradingLimitState(CashLmtStateType cashLmtStateType) {
        switch (cashLmtStateType) {
            case ACTI: {
                return TradingLimitState.ACTIVE;
            }
            case IACT: {
                return TradingLimitState.INACTIVE;
            }
        }
        throw new IllegalStateException("Invalid trading limit state.");
    }
}

