/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.datamodel.AbstractTradeDataModel;
import com.deutscheboerse.comxerv.comtrader.datamodel.HalfTradeDataModelListenerAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.SettlementState;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import org.mapdb.serializer.SerializerJava;

public class FullTradeDataModel
extends AbstractTradeDataModel<FullTrade> {
    private final UserService userService;

    public FullTradeDataModel(ApplicationContext applicationContext) {
        super(applicationContext, "fullTrades", new SerializerJava());
        this.userService = applicationContext.getService(UserService.class);
    }

    @Override
    public Class<FullTrade> getEntityClass() {
        return FullTrade.class;
    }

    @Override
    public FullTrade add(FullTrade broadcastTrade) {
        if (broadcastTrade == null) {
            return null;
        }
        FullTrade existingTrade = (FullTrade)this.findById((Long)broadcastTrade.getId());
        if (existingTrade == null) {
            this.setInitialSettlementInfo(broadcastTrade);
            this.getEntities().put((Long)broadcastTrade.getId(), broadcastTrade);
            return broadcastTrade;
        }
        if (existingTrade.getRevisionNumber() > broadcastTrade.getRevisionNumber()) {
            return existingTrade;
        }
        existingTrade.merge(broadcastTrade);
        this.getEntities().put((Long)existingTrade.getId(), existingTrade);
        return existingTrade;
    }

    @Override
    public FullTrade remove(FullTrade entity) {
        if (entity.allHalfTrades().map(HalfTrade::getRevisionNumber).allMatch(r -> entity.getRevisionNumber() == r.longValue())) {
            entity.allHalfTrades().forEach(ht -> ht.setDirty(true));
            return super.remove(entity);
        }
        return entity;
    }

    public void registerHalfTradeListener(DataModelListener<HalfTrade> dataModelListener) {
        this.registerHencePostOperationListener(new HalfTradeDataModelListenerAdapter(dataModelListener));
    }

    private void setInitialSettlementInfo(FullTrade trade) {
        TradeSettlement settlement = new TradeSettlement();
        settlement.setId(trade.getTradeId());
        settlement.setTradeRevisionNumber(-1L);
        settlement.setStlmntRevisionNumber(-1L);
        settlement.setSettlementState(this.hasPermissionsForTradeSettlements() && !trade.isDecomposed() ? SettlementState.INIT : SettlementState.NOT_AVAILABLE);
        trade.setTradeSettlement(settlement);
    }

    private boolean hasPermissionsForTradeSettlements() {
        User ownUser = this.userService.getOwnUser();
        return ownUser.hasPermissionsForTradeSettlements();
    }
}

