/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.AbstractDataQuery;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DataStreamQuery<T extends BroadcastEntity>
extends AbstractDataQuery<T> {
    private final Supplier<Stream<T>> dataStream;

    public DataStreamQuery(Supplier<Stream<T>> dataStream) {
        this.dataStream = dataStream;
    }

    public DataStreamQuery(Supplier<Stream<T>> dataStream, Predicate<T> filter) {
        super(filter);
        this.dataStream = dataStream;
    }

    @Override
    protected DataQuery<T> newInstance(Predicate<T> filter) {
        return new DataStreamQuery<T>(this.dataStream, filter);
    }

    @Override
    public Stream<T> getAll() {
        return this.dataStream.get().filter(this.getFilter());
    }

    @Override
    public Optional<T> getFirst() {
        return this.getAll().findFirst();
    }

    @Override
    public Optional<T> getAny() {
        return ((Stream)this.dataStream.get().parallel()).filter(this.getFilter()).findAny();
    }
}

