/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.DataStreamQuery;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.SortedSmallFastDataModelQuery;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Singleton
class UserQueriesImpl
implements UserQueries {
    private final SmallFastDataModel<Integer, User> dataModel;
    private final Map<MemberCodeIndexKey, User> memberCodeIndex = new ConcurrentHashMap<MemberCodeIndexKey, User>();

    @Inject
    public UserQueriesImpl(ApplicationContext applicationContext) {
        this.dataModel = applicationContext.getSmallDataModel(User.class);
        this.dataModel.registerListener((DataModelListener<User>)new AbstractDataModelListener<User>(){

            @Override
            public DataModelListener.NotificationResult notifyRemove(User object) {
                UserQueriesImpl.this.clearMemberCodeIndexForUser(object);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                UserQueriesImpl.this.clearMemberCodeIndex();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(User object) {
                UserQueriesImpl.this.clearMemberCodeIndex();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    private void clearMemberCodeIndexForUser(User user) {
        this.memberCodeIndex.remove(new MemberCodeIndexKey(user.getMemberId(), user.getUserCode()));
    }

    private void clearMemberCodeIndex() {
        this.memberCodeIndex.clear();
    }

    @Override
    public DataQuery<User> findUsersByMemberId(String memberId, String[] userRoles) {
        return new SortedSmallFastDataModelQuery<Integer, User>(this.dataModel, User::compareTo).addFilter(EntityFilters.propertyEquals(User::getMemberId, memberId)).addFilter(user -> Stream.of(userRoles).anyMatch(user.getRoles()::hasRole));
    }

    @Override
    public DataQuery<User> findActiveBrokers() {
        return this.findActiveUsersByExchange().addFilter(user -> user.getRoles().isBroker());
    }

    @Override
    public DataQuery<User> findActiveTraders() {
        return this.findActiveUsersByExchange().addFilter(this::canTradeOnHisOwnAccount);
    }

    @Override
    public DataQuery<User> findActiveTradersByBalancingGroupIds(Set<String> balancingGroupIds) {
        Predicate<User> userIsAssignedToBg = u -> balancingGroupIds.stream().anyMatch(u::containsBalancingGroupId);
        return this.findActiveUsersByExchange().addFilter(userIsAssignedToBg).addFilter(this::canTradeOnHisOwnAccount);
    }

    private boolean canTradeOnHisOwnAccount(User u) {
        return u.getRoles().isTrader() || u.getRoles().isBroker() && u.getRoles().isOwnTrading();
    }

    @Override
    public DataQuery<User> findActiveTradersByMemberId(String memberId) {
        return this.findActiveUsersByMemberId(memberId).addFilter(this::canTradeOnHisOwnAccount);
    }

    @Override
    public DataQuery<User> findByMemberIdAndCode(String memberId, String userCode) {
        User user = this.getByMemberIdAndCode(memberId, userCode);
        return new DataStreamQuery<User>(() -> user != null ? Stream.of(user) : Stream.empty());
    }

    private User getByMemberIdAndCode(String memberId, String userCode) {
        return this.memberCodeIndex.computeIfAbsent(new MemberCodeIndexKey(memberId, userCode), key -> this.dataModel.getAllEntitiesAsStream().filter(user -> memberId.equals(user.getMemberId()) && userCode.equals(user.getUserCode())).findFirst().orElse(null));
    }

    private DataQuery<User> findActiveUsersByMemberId(String memberId) {
        return this.findActiveUsersByExchange().addFilter(EntityFilters.propertyEquals(User::getMemberId, memberId));
    }

    private DataQuery<User> findActiveUsersByExchange() {
        return new SortedSmallFastDataModelQuery<Integer, User>(this.dataModel, User::compareTo).addFilter(EntityFilters.propertyEquals(User::getSuspensionType, SuspensionType.ACTIVE));
    }

    private static final class MemberCodeIndexKey {
        private final String memberId;
        private final String userCode;

        public MemberCodeIndexKey(String memberId, String userCode) {
            this.memberId = memberId;
            this.userCode = userCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberCodeIndexKey that = (MemberCodeIndexKey)o;
            if (this.memberId != null ? !this.memberId.equals(that.memberId) : that.memberId != null) {
                return false;
            }
            return !(this.userCode != null ? !this.userCode.equals(that.userCode) : that.userCode != null);
        }

        public int hashCode() {
            int result = this.memberId != null ? this.memberId.hashCode() : 0;
            result = 31 * result + (this.userCode != null ? this.userCode.hashCode() : 0);
            return result;
        }
    }
}

