/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.UserDefaultAwareEntity;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.StringUtils;

public class BalancingGroup
extends UserDefaultAwareEntity
implements Comparable<BalancingGroup>,
RevisionNumbered,
Mergeable<BalancingGroup>,
DisplayName {
    public static final String USE_BG_ID_AS_NAME_APPLICATION_PROPERTY = "useBgIdAsName";
    private Set<String> productIds = Collections.emptySet();
    private Set<String> deliveryAreaIds = Collections.emptySet();
    private Set<String> assignedBgIds = Collections.emptySet();
    private final StringProperty name = new SimpleStringProperty();
    private final LongProperty revisionNumber;
    private final BooleanProperty otcTrading = new SimpleBooleanProperty(false);
    private final StringProperty memberId;
    private final ObjectProperty<SuspensionType> suspensionType;

    public BalancingGroup() {
        this.revisionNumber = new SimpleLongProperty();
        this.suspensionType = new SimpleObjectProperty<SuspensionType>(SuspensionType.ACTIVE);
        this.memberId = new SimpleStringProperty();
    }

    public Set<String> getProductIds() {
        return Collections.unmodifiableSet(this.productIds);
    }

    public Set<String> getDeliveryAreaIds() {
        return Collections.unmodifiableSet(this.deliveryAreaIds);
    }

    public Set<String> getAssignedBgIds() {
        return Collections.unmodifiableSet(this.assignedBgIds);
    }

    public void setProductIds(Collection<String> productIds) {
        this.productIds = productIds == null ? Collections.emptySet() : new HashSet<String>(productIds);
    }

    public void setDeliveryAreaIds(Collection<String> deliveryAreaIds) {
        this.deliveryAreaIds = deliveryAreaIds == null ? Collections.emptySet() : new HashSet<String>(deliveryAreaIds);
    }

    public void setAssignedBgIds(Collection<String> assignedBgIds) {
        this.assignedBgIds = assignedBgIds == null ? Collections.emptySet() : new HashSet<String>(assignedBgIds);
    }

    public boolean containsProductId(String productId) {
        return this.productIds.contains(productId);
    }

    public boolean containsDeliveryAreaId(String deliveryAreaId) {
        return this.deliveryAreaIds.contains(deliveryAreaId);
    }

    public boolean containsAssignedBgId(String assignedBgId) {
        return this.assignedBgIds.contains(assignedBgId);
    }

    public String toString() {
        return (String)this.getId();
    }

    @Override
    public Class getEntityClass() {
        return BalancingGroup.class;
    }

    @Override
    public int compareTo(BalancingGroup balancingGroup) {
        return ((String)this.getId()).compareTo((String)balancingGroup.getId());
    }

    public boolean isOtcTrading() {
        return this.otcTrading.get();
    }

    public BooleanProperty otcTradingProperty() {
        return this.otcTrading;
    }

    public void setOtcTrading(boolean otcTrading) {
        this.otcTrading.set(otcTrading);
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    @Override
    public void merge(BalancingGroup balancingGroup) {
        this.setName(balancingGroup.getName());
        this.setOtcTrading(balancingGroup.isOtcTrading());
        this.setSuspensionType(balancingGroup.getSuspensionType());
        this.revisionNumber.set(balancingGroup.getRevisionNumber());
        this.setProductIds(balancingGroup.getProductIds());
        this.setDeliveryAreaIds(balancingGroup.getDeliveryAreaIds());
        this.setAssignedBgIds(balancingGroup.getAssignedBgIds());
    }

    @Override
    public String getDisplayName() {
        return StringUtils.isEmpty(this.getName()) ? (String)this.getId() : this.getName();
    }

    public SuspensionType getSuspensionType() {
        return (SuspensionType)((Object)this.suspensionType.get());
    }

    public ObjectProperty<SuspensionType> suspensionTypeProperty() {
        return this.suspensionType;
    }

    public void setSuspensionType(SuspensionType suspensionType) {
        this.suspensionType.set(suspensionType);
    }

    public String getMemberId() {
        return (String)this.memberId.get();
    }

    public StringProperty memberIdProperty() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId.set(memberId);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public StringProperty nameProperty() {
        return this.name;
    }
}

