/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingRecord;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderbookValueWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(OrderbookValueWrapper.class);
    private final ObjectProperty<Orderbook> orderbook;
    private final ContractAdditionOrigin origin;
    private final Consumer<Orderbook> contractBecameInactive;
    private final ChangeListener<ContractStatus> contractStatusChangeListener;
    private final ChangeListener<ContractStatus> weakContractStatusChangeListener;
    private final ChangeListener<ContractStatus> obStatusChangeListener;
    private final ChangeListener<ContractStatus> weakObStatusChangeListener;
    private final ObjectProperty<AlertingRecord> alertingInfo;

    public OrderbookValueWrapper(Orderbook initialOrderbook, ContractAdditionOrigin origin, Consumer<Orderbook> contractBecameInactive, BiConsumer<Orderbook, Boolean> compaundContractStatus) {
        this(origin, contractBecameInactive, compaundContractStatus, null);
        this.setOrderbook(initialOrderbook);
    }

    public OrderbookValueWrapper(ContractAdditionOrigin origin, Consumer<Orderbook> contractBecameInactive, BiConsumer<Orderbook, Boolean> compaundContractStatus, Consumer<OrderbookValueWrapper> orderbookChanged) {
        this.contractBecameInactive = contractBecameInactive;
        this.orderbook = new SimpleObjectProperty<Object>(null);
        this.alertingInfo = new SimpleObjectProperty<Object>(null);
        this.origin = origin;
        this.contractStatusChangeListener = this::contractStatusChanged;
        this.weakContractStatusChangeListener = new WeakChangeListener<ContractStatus>(this.contractStatusChangeListener);
        this.obStatusChangeListener = (observable2, oldValue, newValue) -> compaundContractStatus.accept(this.getOrderbook(), Boolean.TRUE);
        this.weakObStatusChangeListener = new WeakChangeListener<ContractStatus>(this.obStatusChangeListener);
        this.orderbook.addListener((observable1, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.getContract().getCompoundStatus().contractStatusProperty().removeListener(this.weakContractStatusChangeListener);
                oldValue.statusProperty().addListener(this.weakObStatusChangeListener);
            }
            if (newValue != null) {
                newValue.getContract().getCompoundStatus().contractStatusProperty().addListener(this.weakContractStatusChangeListener);
                newValue.statusProperty().addListener(this.weakObStatusChangeListener);
            }
            if (orderbookChanged != null) {
                orderbookChanged.accept(this);
            }
        });
    }

    private void contractStatusChanged(ObservableValue<? extends ContractStatus> observable2, ContractStatus oldValue, ContractStatus newValue) {
        if (LOG.isDebugEnabled() && this.getOrderbook() != null) {
            LOG.debug("Status of orderbook {}-{} changed {}->{}", this.getOrderbook().getContract().getName(), this.getOrderbook().getDeliveryArea().getName(), oldValue, newValue);
        }
        if (newValue == null || newValue.isInactive()) {
            this.contractBecameInactive.accept(this.getOrderbook());
        }
    }

    public Orderbook getOrderbook() {
        return (Orderbook)this.orderbook.get();
    }

    public ObjectProperty<Orderbook> orderbookProperty() {
        return this.orderbook;
    }

    public void setOrderbook(Orderbook orderbook) {
        this.orderbook.set(orderbook);
    }

    public ContractAdditionOrigin getOrigin() {
        return this.origin;
    }

    public void setAlertingInfo(AlertingRecord alertingInfo) {
        this.alertingInfo.set(alertingInfo);
    }

    public AlertingRecord getAlertingInfo() {
        return (AlertingRecord)this.alertingInfo.get();
    }

    public ObjectProperty<AlertingRecord> alertingInfoProperty() {
        return this.alertingInfo;
    }
}

