/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.property.binding;

import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import javafx.beans.binding.BooleanBinding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsTomorrowContractBinding
extends BooleanBinding {
    private static final Logger LOG = LoggerFactory.getLogger(IsTomorrowContractBinding.class);
    private final DateTime deliveryStart;
    private final DateTimeZone serverTimeZone;
    private final boolean spansOverMidnight;

    public IsTomorrowContractBinding(Contract contract, SystemInfo systemInfo) {
        if (systemInfo != null) {
            this.serverTimeZone = contract.getProduct() == null || DateTimeZone.forID(contract.getProduct().getTimeZone()).equals(systemInfo.getTimeZone()) ? systemInfo.getTimeZone() : DateTimeZone.forID(contract.getProduct().getTimeZone());
        } else {
            this.serverTimeZone = DateTimeZone.getDefault();
            LOG.error("systemInfo is null used default timezone");
        }
        this.deliveryStart = contract.getDeliveryStart();
        DateTime deliveryEnd = contract.getDeliveryEnd();
        DateTime nextStartOfDayAfterDeliveryStart = this.deliveryStart.withTimeAtStartOfDay().plusDays(1);
        boolean bl = this.spansOverMidnight = this.deliveryStart.isBefore(nextStartOfDayAfterDeliveryStart) && (deliveryEnd == null || deliveryEnd.isAfter(nextStartOfDayAfterDeliveryStart));
        if (!this.spansOverMidnight) {
            this.bind(new WeakObservableValue<String>(contract.nameProperty()));
        }
    }

    @Override
    protected boolean computeValue() {
        if (this.spansOverMidnight) {
            return false;
        }
        DateTime now = DateTime.now(this.serverTimeZone);
        DateTime startOfTomorrow = now.plusDays(1).withTimeAtStartOfDay();
        DateTime endOfTomorrow = now.plusDays(2).withTimeAtStartOfDay();
        return new Interval((ReadableInstant)startOfTomorrow, (ReadableInstant)endOfTomorrow).contains(this.deliveryStart);
    }
}

