/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.LargePersistableDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.FullTradeQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.TradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractTradePanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.MemberFilterField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ProgressBarBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarToggleButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.RelevantFullTradeProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradePanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javax.annotation.Nullable;
import org.apache.commons.lang3.IntegerRange;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DraggableComponent(forUserWithUserRole={"ROLE_ADMIN", "ROLE_EPEX_SALES", "ROLE_BROKER"}, nameKey="ownTradePanel_header_label_all", descriptionKey="ownTradePanel_description_all", adminDescriptionKey="ownTradePanel_description_admin_all")
@PanelWithLoadingIndicator(entityClasses={FullTrade.class})
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="tableView", overrideId="AllTradePanel", strategy=TableViewOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="bottomToolbar", overrideId="AllTradePanel", strategy=BottomToolbarOverrideGuiStrategy.class)})
public class AllTradePanel
extends AbstractTradePanel<FullTrade> {
    private static final Logger LOG = LoggerFactory.getLogger(AllTradePanel.class);
    private final TradeService tradeService;
    private final UserService userService;
    private final TimeService timeService;
    @FXML
    private Label tradeCancellationText;
    @FXML
    private LabeledBottomToolbarToggleButton pauseOrResumeButton;
    @FXML
    private ProgressBarBox progressBarBox;
    @FXML
    private LabeledBottomToolbarButton processRecallButton;
    @FXML
    private LabeledBottomToolbarButton cancelButton;
    @FXML
    private FilterPopupButton<FullTrade> filterButton;
    @FXML
    private MemberFilterField memberFilterField;
    private FilteredTableView<FullTrade> filteredTableView;
    private final Predicate<FullTrade> baseFilter;

    public AllTradePanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public AllTradePanel(ApplicationContext appContext) {
        super(appContext);
        this.tradeService = appContext.getService(TradeService.class);
        this.userService = appContext.getService(UserService.class);
        this.timeService = appContext.getService(TimeService.class);
        this.baseFilter = trade -> true;
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.processRecallButton.disableProperty().bind(DependentBinding.get(() -> this.disableButtonIfConditionNotMet(this.tradeService::isTradeRecallProcessingPossible), this.getSelectedItems()));
        this.cancelButton.disableProperty().bind(DependentBinding.get(() -> this.disableButtonIfConditionNotMet(this.tradeService::isTradeCancellationPossible), this.getSelectedItems()));
        LargePersistableDataModel<Long, FullTrade> dataModel = this.getAppContext().getLargeDataModel(FullTrade.class);
        TradeQueries tradeQueries = this.getAppContext().getService(FullTradeQueries.class);
        this.filteredTableView = new FilteredTableView<FullTrade>(this.tradeTableView, this.baseFilter, new RelevantFullTradeProvider(tradeQueries, this.dateFilterComponent, dataModel), true);
        this.filterButton.initialize(this.filteredTableView);
        InvalidationListener setQuickFilterListener = observable2 -> this.reloadQuickFilter();
        this.dateFilterComponent.filterProperty().addListener(setQuickFilterListener);
        this.memberFilterField.filterProperty().addListener(setQuickFilterListener);
        this.showDecomposedTrades.fullTraderFilterProperty().addListener(setQuickFilterListener);
        this.reloadQuickFilter();
        this.refreshButtonVisibility();
        this.progressBarBox.progressProperty().bind(this.tradeService.getTradeCancellationProgress().currentProgressProperty());
        this.progressBarBox.visibleProperty().bind(this.tradeService.getTradeCancellationProgress().inProgressProperty());
        this.progressBarBox.disableProperty().bind(this.tradeService.getTradeCancellationProgress().inProgressProperty().not());
        this.tradeCancellationText.visibleProperty().bind(this.tradeService.getTradeCancellationProgress().inProgressProperty());
        this.dateFilterComponent.ignoreFullHourEventProperty().bind(this.pauseOrResumeButton.selectedProperty());
    }

    private boolean disableButtonIfConditionNotMet(Predicate<List<FullTrade>> condition) {
        return !condition.test(this.getSelectedItems());
    }

    private void reloadQuickFilter() {
        Predicate<FullTrade> dateFilter = this.dateFilterComponent.getFilter();
        Predicate<FullTrade> memberFilter = this.memberFilterField.getFilter();
        Predicate<FullTrade> showDecomposedTradesFilter = this.showDecomposedTrades.getFullTraderFilter();
        this.filteredTableView.setQuickFilter(dateFilter.and(memberFilter).and(showDecomposedTradesFilter));
    }

    private void refreshButtonVisibility() {
        boolean isAdminForAnyConnection = this.userService.getOwnUserRoles().hasRole("ROLE_ADMIN");
        if (isAdminForAnyConnection) {
            if (!this.bottomToolbar.getToolbarItems().contains(this.processRecallButton)) {
                this.bottomToolbar.getToolbarItems().add(this.processRecallButton);
            }
            if (!this.bottomToolbar.getToolbarItems().contains(this.cancelButton)) {
                this.bottomToolbar.getToolbarItems().add(this.cancelButton);
            }
        } else {
            this.bottomToolbar.getToolbarItems().removeAll((Node[])new Node[]{this.processRecallButton, this.cancelButton});
        }
    }

    @FXML
    public void processRecallTradeButtonClickAction() {
        this.tradeService.processRecallTrades(this.getSelectedItems());
    }

    @FXML
    public void cancelTradeButtonClickAction() {
        this.tradeService.cancelTrades(this.getSelectedItems());
    }

    @Override
    public TradePanelState<FullTrade> getComponentState() {
        return new TradePanelState<FullTrade>(StorableTableLayoutDescriptor.fromTable(this.tradeTableView), this.menu.isExpanded(), this.bottomToolbar.getState(), this.filteredTableView.getCustomFilter().getFilterStates(), this.dateFilterComponent.getDateType(), this.dateFilterComponent.getOffsetInDays(), (Integer)((IntegerRange)this.dateFilterComponent.getTimeframeChoiceBox().getValue()).getMinimum(), (Integer)((IntegerRange)this.dateFilterComponent.getTimeframeChoiceBox().getValue()).getMaximum(), (Integer)this.dateFilterComponent.getHourIntervalChoiceBox().getValue(), this.dateFilterComponent.getAutomaticReloadCheckBox().isSelected(), this.showDecomposedTrades.getState());
    }

    @Override
    public void restoreComponentState(TradePanelState<FullTrade> componentState) {
        super.restoreComponentState(componentState);
        this.filteredTableView.loadCustomFilter(componentState.getColumnFilters());
        this.dateFilterComponent.getHourIntervalChoiceBox().setValue(componentState.getHourInterval());
        this.dateFilterComponent.getAutomaticReloadCheckBox().setSelected(componentState.isAutomaticReload());
        if (!componentState.isAutomaticReload()) {
            this.dateFilterComponent.getTimeframeChoiceBox().setValue(IntegerRange.of(componentState.getTimeframeMin(), componentState.getTimeframeMax()));
        }
    }

    @FXML
    public void pauseOrResume() {
        if (this.pauseOrResumeButton.isSelected()) {
            DateTime serverTime = this.timeService.getServerTime();
            LOG.info("Trade panel freezed at {}", (Object)serverTime);
            this.filteredTableView.setBaseFilter(new TimestampFreezePredicate(serverTime));
            this.pauseOrResumeButton.setText("Resume");
            this.pauseOrResumeButton.setIconStyleClass("button-activate");
        } else {
            LOG.info("Trade panel unfreezed");
            this.filteredTableView.setBaseFilter(this.baseFilter);
            this.pauseOrResumeButton.setText("Pause");
            this.pauseOrResumeButton.setIconStyleClass("button-deactivate");
        }
    }

    protected static class TimestampFreezePredicate
    implements Predicate<FullTrade> {
        private final DateTime timestamp;

        public TimestampFreezePredicate(DateTime timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public boolean test(@Nullable FullTrade trade) {
            if (trade == null) {
                return false;
            }
            return trade.getTimeStamp().isBefore(this.timestamp);
        }
    }
}

