/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractOrderPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AllEntitiesProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterPopupButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.order.OrderPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.BottomToolbarOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OtcOrderService;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javax.annotation.Nullable;

@DraggableComponent(hasPublicAccess=true, nameKey="otcPanel_header_label", descriptionKey="otcPanel_description")
@PanelWithLoadingIndicator(entityClasses={Order.class})
@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="tableView", overrideId="OTCPanel", strategy=TableViewOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="bottomToolbar", overrideId="OTCPanel", strategy=BottomToolbarOverrideGuiStrategy.class)})
public class OTCPanel
extends AbstractOrderPanel {
    @FXML
    private Button acceptButton;
    @FXML
    private Button rejectButton;
    @FXML
    private Button modifyButton;
    @FXML
    private Button deleteButton;
    @FXML
    private Button activateButton;
    @FXML
    private Button deactivateButton;
    @FXML
    private FilterPopupButton<Order> filterButton;
    private FilteredTableView<Order> filteredTableView;

    public OTCPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OTCPanel(ApplicationContext appContext) {
        super(appContext);
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.filteredTableView = new FilteredTableView<Order>(this.orderTableView, this.createNewBaseFilter(), new AllEntitiesProvider(this.getAppContext().getSmallDataModel(Order.class)), true);
        this.orderTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.acceptButton.disableProperty().bind(DependentBinding.get(this::disableAccept, this.getSelectedOrders()));
        this.rejectButton.disableProperty().bind(DependentBinding.get(this::disableReject, this.getSelectedOrders()));
        this.modifyButton.disableProperty().bind(DependentBinding.get(this::disableModify, this.getSelectedOrders()));
        this.deleteButton.disableProperty().bind(DependentBinding.get(this::disableDelete, this.getSelectedOrders()));
        this.activateButton.disableProperty().bind(DependentBinding.get(this::disableActivate, this.getSelectedOrders()));
        this.deactivateButton.disableProperty().bind(DependentBinding.get(this::disableDeactivate, this.getSelectedOrders()));
        this.filterButton.initialize(this.filteredTableView);
    }

    private boolean disableAccept() {
        return !this.getSelectedOrder().filter(order -> this.getOtcOrderService((Order)order).isOtcOrderAcceptable((Order)order)).isPresent();
    }

    private boolean disableReject() {
        return this.getSelectedOrders().isEmpty() || this.getSelectedOrders().stream().anyMatch(order -> !this.getOtcOrderService((Order)order).isOtcOrderRejectable((Order)order));
    }

    private boolean disableModify() {
        return !this.getSelectedOrder().filter(order -> this.getOtcOrderService((Order)order).isOtcOrderModifiable((Order)order)).isPresent();
    }

    private boolean disableDelete() {
        return this.getSelectedOrders().isEmpty() || this.getSelectedOrders().stream().allMatch(order -> !this.getOtcOrderService((Order)order).isOtcOrderCancellable(List.of(order)));
    }

    private boolean disableActivate() {
        return this.getSelectedOrders().isEmpty() || this.getSelectedOrders().stream().anyMatch(order -> !this.getOtcOrderService((Order)order).isOtcOrderModifiable((Order)order) || OrderStatus.HIBERNATE != order.getStatus());
    }

    private boolean disableDeactivate() {
        return this.getSelectedOrders().isEmpty() || this.getSelectedOrders().stream().allMatch(order -> !this.getOtcOrderService((Order)order).isOtcOrderModifiable((Order)order) || OrderStatus.ACTIVE != order.getStatus());
    }

    @Override
    protected void userChanged() {
        this.filteredTableView.setBaseFilter(this.createNewBaseFilter());
    }

    private IsRelevantOtcOrderPredicate createNewBaseFilter() {
        return new IsRelevantOtcOrderPredicate(this.getAppContext());
    }

    private OtcOrderService getOtcOrderService(Order order) {
        return this.getAppContext().getService(OtcOrderService.class, order.getExchange());
    }

    @FXML
    public void acceptSelectedOrdersButtonClickAction() {
        this.getSelectedOrder().ifPresent(order -> {
            order.setPreArrangedAcceptOrReject(AcceptOrRejectType.ACCEPT);
            this.getAppContext().getService(OrderPopup.class).showAcceptOtcOrderPopup((Order)order, this.acceptButton);
            this.orderTableView.getSelectionModel().clearSelection();
        });
    }

    @FXML
    public void rejectSelectedOrdersButtonClickAction() {
        ArrayList<Order> selectionCopy = new ArrayList<Order>(this.getSelectedOrders());
        this.orderTableView.getSelectionModel().clearSelection();
        selectionCopy.forEach(order -> this.getOtcOrderService((Order)order).rejectOtcOrder((Order)order));
        this.orderTableView.getSelectionModel().clearSelection();
    }

    @FXML
    public void modifySelectedOrderButtonClickAction() {
        this.getSelectedOrder().ifPresent(order -> {
            order.setPreArrangedAcceptOrReject(null);
            this.getAppContext().getService(OrderPopup.class).showExtendedOrderPopup((Order)order, false, this.modifyButton);
            this.orderTableView.getSelectionModel().clearSelection();
        });
    }

    private Optional<Order> getSelectedOrder() {
        ObservableList<Order> selectedItems = this.getSelectedOrders();
        return selectedItems.size() == 1 ? Optional.of((Order)selectedItems.get(0)) : Optional.empty();
    }

    private ObservableList<Order> getSelectedOrders() {
        return this.orderTableView.getSelectionModel().getSelectedItems();
    }

    @Override
    public OrderPanelState getComponentState() {
        return new OrderPanelState(StorableTableLayoutDescriptor.fromTable(this.orderTableView), this.menu.isExpanded(), this.bottomToolbar.getState(), this.filteredTableView.getCustomFilter().getFilterStates());
    }

    @Override
    public void restoreComponentState(OrderPanelState componentState) {
        super.restoreComponentState(componentState);
        this.filteredTableView.loadCustomFilter(componentState.getColumnFilters());
    }

    protected static class IsRelevantOtcOrderPredicate
    implements Predicate<Order> {
        private final ApplicationContext applicationContext;

        public IsRelevantOtcOrderPredicate(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public boolean test(@Nullable Order order) {
            if (order == null) {
                return false;
            }
            if (order.getOrderType() != OrderType.OTC_PREARRANGED) {
                return false;
            }
            OwnQuantityLookupService ownQuantityLookupService = this.applicationContext.getService(OwnQuantityLookupService.class);
            if (ownQuantityLookupService == null || !ownQuantityLookupService.isOwnOrder(order)) {
                return false;
            }
            return !order.getStatus().equals(OrderStatus.HIBERNATE) || !this.getOtcOrderService(order).isOtcOrderAcceptable(order) || order.getBalancingGroupId().equals(order.getPreArrangedBalancingGroupId());
        }

        private OtcOrderService getOtcOrderService(Order order) {
            return this.applicationContext.getService(OtcOrderService.class, order.getExchange());
        }
    }
}

