/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.MainPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.GuiStateService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabPanel
extends TabPane
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(TabPanel.class);
    private static final DataFormat DATE_FORMAT__TAB_ID = new DataFormat("com.deutscheboerse.comxerv.comtrader.dateFormat.tabId");
    private static final String HIDDEN_TAB_PANEL_HEADER_STYLE = "hiddenTabPanelHeaderStyle";
    private final ApplicationContext appContext;
    private final MainPanel mainPanel;
    private final ObjectProperty<Boolean> visibleTabs = new SimpleObjectProperty<Boolean>(true);
    private final GuiStateService guiStateService;
    private final ScheduledExecutorService scheduledExecutorService;

    public TabPanel(ApplicationContext appContext, MainPanel mainPanel) {
        this.appContext = appContext;
        this.mainPanel = mainPanel;
        this.guiStateService = appContext.getService(GuiStateService.class);
        this.scheduledExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.setOnDragDetected(mouseEvent -> {
            Dragboard db = this.startDragAndDrop(TransferMode.MOVE);
            ClipboardContent content = new ClipboardContent();
            content.put(DATE_FORMAT__TAB_ID, this.getMainPanel().getSuffix());
            db.setContent(content);
            mouseEvent.consume();
        });
        this.setOnDragDone(dragEvent -> {
            Tab selectedTab;
            if (!dragEvent.isAccepted() && dragEvent.getGestureSource() instanceof TabPanel && (selectedTab = (Tab)this.getSelectionModel().getSelectedItem()) instanceof ContentTab) {
                ContentTab contentTab = (ContentTab)selectedTab;
                if (this.getTabs().size() > 2) {
                    this.openContentTabInNewWindow(contentTab);
                }
            }
            dragEvent.consume();
        });
        this.setOnDragOver(dragEvent -> {
            if (this.isDropAccepted((DragEvent)dragEvent)) {
                dragEvent.acceptTransferModes(TransferMode.MOVE);
            }
            dragEvent.consume();
        });
        this.setOnDragDropped(dragEvent -> {
            String panelId = (String)dragEvent.getDragboard().getContent(DATE_FORMAT__TAB_ID);
            if (panelId != null) {
                TabPanel sourceTabPanel = appContext.getService(MainPanelService.class).getMainPanelBySuffix(panelId).getTabPanel();
                if (sourceTabPanel != this) {
                    ContentTab selectedTab = this.moveSelectedTabToMe(sourceTabPanel);
                    this.getSelectionModel().select(selectedTab);
                }
                dragEvent.setDropCompleted(true);
                dragEvent.consume();
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyCode.TAB.equals((Object)keyEvent.getCode()) && keyEvent.isControlDown() && !keyEvent.isAltDown() && !keyEvent.isMetaDown()) {
                if (!keyEvent.isShiftDown()) {
                    if (this.getSelectionModel().getSelectedIndex() != this.getTabs().size() - 2) {
                        this.getSelectionModel().selectNext();
                    } else {
                        this.getSelectionModel().selectFirst();
                    }
                } else if (this.getSelectionModel().getSelectedIndex() != 0) {
                    this.getSelectionModel().selectPrevious();
                } else {
                    this.getSelectionModel().select(this.getTabs().size() - 2);
                }
                keyEvent.consume();
            }
            if (this.isFocused()) {
                if (!(!KeyCode.RIGHT.equals((Object)keyEvent.getCode()) && !KeyCode.DOWN.equals((Object)keyEvent.getCode()) || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isMetaDown())) {
                    if (this.getSelectionModel().getSelectedIndex() != this.getTabs().size() - 2) {
                        this.getSelectionModel().selectNext();
                    }
                    keyEvent.consume();
                }
                if (KeyEventUtil.isOnlyKeyCode(KeyCode.END, keyEvent)) {
                    this.getSelectionModel().select(this.getTabs().size() - 2);
                    keyEvent.consume();
                }
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener(observable2 -> {
            Tab selectedItem = (Tab)this.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                LOG.info("Selected tab: {}", (Object)selectedItem.getText());
                FxUtil.runInFxThread(() -> this.getMainPanel().getStage().titleProperty().bind(selectedItem.textProperty()));
            }
        });
        this.visibleTabs.addListener((observable2, oldValue, newValue) -> StyleUtil.addStyleClass(this, HIDDEN_TAB_PANEL_HEADER_STYLE, newValue == false));
        appContext.getService(EventBus.class).register(this);
    }

    public void addPlusTab(boolean suspendEditMode) {
        if (suspendEditMode) {
            this.guiStateService.setSuspendEditMode(true);
        }
        this.getTabs().add(new PlusTab(this, this.appContext));
        if (suspendEditMode) {
            this.guiStateService.setSuspendEditMode(false);
        }
    }

    private int getNewContentTabPosition() {
        return this.getTabs().size() - 1;
    }

    public void removeTab(Tab tab) {
        if (this.getTabs().size() <= 2) {
            try {
                this.guiStateService.setSuspendEditMode(true);
                this.getTabs().remove(tab);
                this.removeAllTabs();
                this.getMainPanel().getStage().close();
            }
            finally {
                this.guiStateService.setSuspendEditMode(false);
            }
        } else {
            this.getTabs().remove(tab);
        }
    }

    public ContentTab moveSelectedTabToMe(TabPanel sourceTabPanel) {
        ContentTab selectedTab = (ContentTab)sourceTabPanel.getSelectionModel().getSelectedItem();
        if (sourceTabPanel.getTabs().size() <= 2) {
            try {
                this.guiStateService.setSuspendEditMode(true);
                sourceTabPanel.getTabs().remove(selectedTab);
                this.getTabs().add(this.getNewContentTabPosition(), selectedTab);
                sourceTabPanel.removeAllTabs();
                sourceTabPanel.getMainPanel().getStage().close();
            }
            finally {
                this.guiStateService.setSuspendEditMode(false);
            }
        } else {
            sourceTabPanel.getTabs().remove(selectedTab);
            this.getTabs().add(this.getNewContentTabPosition(), selectedTab);
        }
        return selectedTab;
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public Boolean getVisibleTabs() {
        return (Boolean)this.visibleTabs.get();
    }

    public void setVisibleTabs(Boolean visibleTabs) {
        this.visibleTabs.setValue(visibleTabs);
    }

    public ObjectProperty<Boolean> visibleTabsProperty() {
        return this.visibleTabs;
    }

    private boolean isDropAccepted(DragEvent dragEvent) {
        return !this.equals(dragEvent.getGestureSource());
    }

    public void openContentTabInNewWindow(ContentTab contentTab) {
        this.guiStateService.setSuspendEditMode(true);
        MainPanel newMainPanel = this.appContext.getService(MainPanelService.class).createMainPanel();
        this.removeTab(contentTab);
        newMainPanel.getTabPanel().getTabs().add(0, contentTab);
        newMainPanel.getTabPanel().getSelectionModel().select(contentTab);
        newMainPanel.getTabPanel().addPlusTab(false);
        FxUtil.runLater(() -> {
            newMainPanel.getStage().setHeight(this.getMainPanel().getStage().getHeight());
            newMainPanel.getStage().setWidth(this.getMainPanel().getStage().getWidth());
        });
        this.guiStateService.setSuspendEditMode(false);
    }

    public void moveTabLeft(ContentTab tab) {
        ObservableList<Tab> tabs = this.getTabs();
        int index = tabs.indexOf(tab);
        if (index >= 1) {
            tabs.remove(tab);
            tabs.add(index - 1, tab);
            this.getSelectionModel().select(tab);
        }
    }

    public void moveTabRight(ContentTab tab) {
        ObservableList<Tab> tabs = this.getTabs();
        int index = tabs.indexOf(tab);
        if (index >= 0 && index <= tabs.size() - 3) {
            tabs.remove(tab);
            tabs.add(index + 1, tab);
            this.getSelectionModel().select(tab);
        }
    }

    @Override
    public void destroy() {
        this.unregisterAllTabs();
        this.getTabs().clear();
        this.appContext.getService(EventBus.class).unregister(this);
    }

    private void unregisterAllTabs() {
        this.getTabs().stream().filter(ContentTab.class::isInstance).forEach(tab -> {
            ContentTab contentTab = (ContentTab)tab;
            contentTab.unregisterFromAll();
        });
    }

    public void removeAllTabs() {
        this.unregisterAllTabs();
        this.getTabs().clear();
    }

    @Subscribe
    public void handleEditEvent(EditEvent editEvent) {
        if (editEvent.isEditMode()) {
            this.setVisibleTabs(true);
        }
    }

    public void forceDisplayAllTabs(CountDownLatch countDownOnFinished) {
        Tab initiallySelectedTab = (Tab)this.getSelectionModel().getSelectedItem();
        this.getSelectionModel().selectFirst();
        List tabsCopy = this.getTabs().stream().filter(tab -> !(tab instanceof PlusTab)).filter(tab -> !tab.equals(initiallySelectedTab)).collect(Collectors.toCollection(ArrayList::new));
        this.scheduledExecutorService.schedule(() -> this.selectTab(tabsCopy, initiallySelectedTab, countDownOnFinished), 100L, TimeUnit.MILLISECONDS);
    }

    private void selectTab(List<Tab> tabsCopy, Tab initiallySelectedTab, CountDownLatch countDownOnFinished) {
        if (tabsCopy.isEmpty()) {
            this.getSelectionModel().select(initiallySelectedTab);
            countDownOnFinished.countDown();
        } else {
            Tab tab = tabsCopy.remove(0);
            this.getSelectionModel().select(tab);
            this.scheduledExecutorService.schedule(() -> this.selectTab(tabsCopy, initiallySelectedTab, countDownOnFinished), 100L, TimeUnit.MILLISECONDS);
        }
    }

    public static class PlusTab
    extends Tab {
        private PlusTab(TabPanel parent, ApplicationContext appContext) {
            super("+");
            this.setId("plusTab");
            this.setClosable(false);
            this.setOnSelectionChanged(event -> {
                if (this.isSelected()) {
                    ContentTab contentTab = new ContentTab(appContext);
                    contentTab.setText(Util.getLabel("commons_newTab"));
                    contentTab.editName();
                    parent.getTabs().add(Math.max(0, parent.getTabs().indexOf(this)), contentTab);
                    parent.getSelectionModel().select(contentTab);
                    appContext.getService(GuiStateService.class).startEditMode();
                }
            });
        }
    }
}

