/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.BasketEntry;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.ContextMenuOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.Basket;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

@OverrideGuiConfiguration(field="items", overrideId="BasketEntryContextMenu", strategy=ContextMenuOverrideGuiStrategy.class)
public class BasketEntryContextMenu
extends ContextMenu {
    private final BasketEntry basketEntry;
    private final Basket basket;

    public static ContextMenu createContextMenu(BasketEntry basketEntry, ApplicationContext appContext) {
        BasketEntryContextMenu contextMenu = new BasketEntryContextMenu(basketEntry, appContext);
        appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(contextMenu);
        return contextMenu;
    }

    protected BasketEntryContextMenu(BasketEntry basketEntry, ApplicationContext appContext) {
        this.basketEntry = basketEntry;
        this.basket = appContext.getService(BasketService.class).getActiveBasket();
        MenuItem deleteItem = new MenuItem(Util.getLabel("commons_cancel"));
        deleteItem.setGraphic(new IconView(ContextMenuIcon.CANCEL.getIconStyleClass()));
        deleteItem.setOnAction(event -> this.basket.remove(this.basketEntry));
        this.getItems().add(deleteItem);
        MenuItem editItem = new MenuItem(Util.getLabel("commons_modify"));
        editItem.setGraphic(new IconView(ContextMenuIcon.MODIFY.getIconStyleClass()));
        editItem.setOnAction(event -> appContext.getService(OrderPopup.class).showExtendedOrderPopup(this.prepareOrderToSubmit(this.basketEntry), true, editItem.getGraphic()));
        this.getItems().add(editItem);
    }

    private Order prepareOrderToSubmit(BasketEntry entry) {
        Order order = entry.getOrder();
        return order;
    }
}

