/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractMemberField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;

public class MemberFilterField
extends AbstractMemberField
implements StorableBottomToolbarNode<String> {
    private final ObservableValue<Predicate<FullTrade>> filter = DependentBinding.get(MemberFilter::new, this.valueProperty(), t -> true);

    public MemberFilterField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public MemberFilterField(ApplicationContext applicationContext) {
        super(applicationContext);
        this.valid.bind(this.textProperty().isEmpty().or(this.valueProperty().isNotNull()));
    }

    @Override
    protected boolean filter(Member member) {
        return true;
    }

    @Override
    public String getState() {
        return this.getValue() != null ? (String)((Member)this.getValue()).getId() : "";
    }

    @Override
    public void restoreSavedState(String state) {
        Optional.ofNullable((Member)this.memberDataModel.findById(state)).map(this.getToStringConverter()).ifPresent(this::setText);
    }

    public ObservableValue<Predicate<FullTrade>> filterProperty() {
        return this.filter;
    }

    public Predicate<FullTrade> getFilter() {
        return this.filter.getValue();
    }

    @Override
    public Node getPreviewForConfigTable() {
        TextField preview = new TextField(Util.getLabel("commons_member"));
        preview.setDisable(true);
        return preview;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_ownTradePanel_memberFilter");
    }

    private static final class MemberFilter
    implements Predicate<FullTrade> {
        private final Member member;

        public MemberFilter(Member member) {
            this.member = member;
        }

        @Override
        public boolean test(FullTrade fullTrade) {
            return this.member == null || fullTrade.getBuyOrder() != null && ((String)this.member.getId()).equals(fullTrade.getBuyOrder().getMemberCode()) || fullTrade.getSellOrder() != null && ((String)this.member.getId()).equals(fullTrade.getSellOrder().getMemberCode());
        }
    }
}

