/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class SearchBox
extends HBox {
    @FXML
    private TextField textBox;
    @FXML
    private Button clearButton;
    @FXML
    private Button switchButton;
    @FXML
    private Label switchButtonLabel;
    private Mode mode;

    public SearchBox() {
        FXMLLoaderWithContext.loadCustomComponent(FXMLLoaderWithContext.getAppContext(), this);
    }

    public void initialize() {
        StyleUtil.addStyleClass(this, "searchBox");
        this.useContractSearch();
        this.textBox.textProperty().addListener((observable2, oldValue, newValue) -> this.clearButton.setVisible(this.textBox.getText().length() != 0));
    }

    private void useContractSearch() {
        this.mode = Mode.CONTRACT_SEARCH;
        this.switchButtonLabel.setText(Mode.CONTRACT_SEARCH.getButtonText());
        this.switchButton.getTooltip().setText(Util.getLabel("commons_searchContract"));
    }

    private void useProductSearch() {
        this.mode = Mode.PRODUCT_SEARCH;
        this.switchButtonLabel.setText(Mode.PRODUCT_SEARCH.getButtonText());
        this.switchButton.getTooltip().setText(Util.getLabel("commons_searchProduct"));
    }

    @FXML
    public void clearAction() {
        this.textBox.setText("");
        this.textBox.requestFocus();
    }

    @FXML
    public void switchAction() {
        String oldSearchText = this.textBox.getText();
        this.textBox.setText("");
        this.textBox.requestFocus();
        if (this.mode == Mode.CONTRACT_SEARCH) {
            this.useProductSearch();
        } else {
            this.useContractSearch();
        }
        this.textBox.setText(oldSearchText);
    }

    public TextField getTextBox() {
        return this.textBox;
    }

    public String getPromptText() {
        return this.textBox.getPromptText();
    }

    public void setPromptText(String promptText) {
        this.textBox.setPromptText(promptText);
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        CONTRACT_SEARCH("C"),
        PRODUCT_SEARCH("P");

        private String buttonText;

        private Mode(String buttonText) {
            this.buttonText = buttonText;
        }

        public String getButtonText() {
            return this.buttonText;
        }
    }
}

