/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.service.MemoryService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class MemoryWidget
extends Label
implements BottomToolbarNode,
Destroyable {
    private final MemoryService memoryService;
    private final Consumer<String> memoryUpdatesConsumer;

    public MemoryWidget() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected MemoryWidget(ApplicationContext applicationContext) {
        this.memoryService = applicationContext.getService(MemoryService.class);
        this.memoryUpdatesConsumer = memory -> FxUtil.runInFxThread(() -> this.setText((String)memory));
        this.memoryService.registerForUpdates(this.memoryUpdatesConsumer);
        TooltipUtils.setTooltip(this, this.getDescription());
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_mainPanel_memoryWidget");
    }

    @Override
    public Node getPreviewForConfigTable() {
        Label label = new Label();
        label.textProperty().bind(Bindings.when(this.textProperty().isEmpty()).then(Util.getLabel("commons_memberWidget")).otherwise(this.textProperty()));
        label.setDisable(true);
        return label;
    }

    @Override
    public void destroy() {
        this.memoryService.unregisterForUpdates(this.memoryUpdatesConsumer);
    }
}

