/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class OnBehalfInfoBox
extends HBox
implements BottomToolbarNode,
LabeledBottomToolbarNode {
    @FXML
    private Label onBehalfInfoText;
    @FXML
    private Label onBehalfInfoLabel;
    private final BooleanProperty showLabel = new SimpleBooleanProperty(true);
    private final ObservableValue<User> selectedOnBehalfUser;
    private final InvalidationListener onBehalfUserChange;

    public OnBehalfInfoBox() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OnBehalfInfoBox(ApplicationContext appContext) {
        this.selectedOnBehalfUser = appContext.getService(OnBehalfService.class).onBehalfUserProperty();
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.onBehalfUserChange = observable2 -> this.refresh();
        this.selectedOnBehalfUser.addListener(new WeakInvalidationListener(this.onBehalfUserChange));
        this.showLabel.addListener(observable2 -> this.refresh());
        this.refresh();
    }

    public void initialize() {
        TooltipUtils.setTooltip(this.onBehalfInfoText, this.getDescription());
    }

    private void refresh() {
        String onBehalfInfo = this.createOnBehalfInfoString(this.selectedOnBehalfUser.getValue());
        this.onBehalfInfoText.setText(onBehalfInfo);
        this.getChildren().clear();
        if (this.selectedOnBehalfUser.getValue() != null) {
            if (this.isShowLabel()) {
                this.getChildren().add(this.onBehalfInfoLabel);
            }
            this.getChildren().add(this.onBehalfInfoText);
        }
    }

    private String createOnBehalfInfoString(User user) {
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            sb.append(user.getExchange());
            if (user.getMember() != null) {
                sb.append(" ");
                sb.append(user.getMember().getDisplayName());
            }
            sb.append(" / ");
            sb.append(user.getDisplayName());
        }
        return sb.toString();
    }

    @Override
    public Node getPreviewForConfigTable() {
        Label label = new Label();
        label.textProperty().bind(Bindings.when(this.onBehalfInfoText.textProperty().isEmpty()).then(Util.getLabel("commons_onBehalfTrading_space")).otherwise(this.onBehalfInfoText.textProperty()));
        label.setDisable(true);
        return label;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_mainPanel_onBehalfTrading");
    }

    @Override
    public boolean isShowLabel() {
        return this.showLabel.get();
    }

    @Override
    public BooleanProperty showLabelProperty() {
        return this.showLabel;
    }

    @Override
    public void setShowLabel(boolean showLabel) {
        this.showLabel.set(showLabel);
    }
}

